/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.rule;

// Java classes
import java.util.Date;

// Library classes

// Framework classes
import gov.va.med.fw.rule.RuleException;

// ESR Classes
import gov.va.med.esr.common.model.lookup.AddressChangeSource;
import gov.va.med.esr.common.model.lookup.AddressType;
import gov.va.med.esr.common.model.lookup.BadAddressReason;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.person.Association;
import gov.va.med.esr.common.model.person.Person;



/**
 * @author Carlos Ruiz
 * @version 1.0
 */
public interface ContactInformationInput extends BaseInput {
    public Association getAssociation();

    public boolean isAddressTypeExisted();

    public boolean isAddressDeleted();

    public boolean isVeteranAddressMatched();

    public boolean isAddressDateValid();

    public boolean isAddressActive();
    
    public boolean isAddressTypeEqual(String type);
    
    /**
     * This method compares Line 1, City, State, Zip and Country or 
     * Address Line 1, City, Province, Postal Code and Country to check the address for changes.
     */
    public boolean isAddressChanged();

    public boolean isAddressTypeValid();

    public boolean isAddressAfter();
    
    public boolean isAddressUpdateDateEqual();

    public boolean isAddressStateValid();
    
    public boolean isValidUSAState();

    public Person getPerson();

    public String getAssociationType();

    public String getAddressLineOne();

    public String getPristineAddressLineOne();

    public String getAddressLineTwo();

    public String getPristineAddressLineTwo();

    public Date getAddressStartDate();
    public Date getAddressEndDate();
    
    public AddressType getAddressTypeCode();    

    public Date getPristineAddressStartDate();
    
    public Date getPristineAddressEndDate();

    public String getAddressLineThree();

    public String getPristineAddressLineThree();

    public Date getChangeDate();

    public VAFacility getChangeSite();

    public String getCity();

    public String getPristineCity();

    public String getCounty();

    public String getPristineCounty();

    public String getPristineAddressStateCode();

    public String getProvince();

    public String getPristineProvince();

    public String getCountry();

    public String getPristineCountry();

    public BadAddressReason getBadAddressReasonText();
    
    public BadAddressReason getResultBadAddressReasonText();

    public BadAddressReason getPristineBadAddressReasonText();

    public AddressChangeSource getSourceOfChange();

    public AddressChangeSource getPristineSourceOfChange();

    public String getPhoneNumber();

    public String getPristinePhoneNumber();

    public String getPostalCode();
    public String getPristinePostalCode();
    
    public String getZipPlus4();
    public String getPristineZipPlus4();

    public void setAddressEndDate(Date d);

    public void setAddressLineOne(String line);

    public void setAddressLineTwo(String line);

    public void setAddressLineThree(String line);

    public void setChangeDate(Date date);

    public void setCity(String city);

    public void setCounty(String county);

    public void setProvince(String province);

    public void setCountry(String country);
    
    public void setBadAddressReasonText(BadAddressReason.Code text) throws RuleException;

    public void setSourceOfChange(AddressChangeSource text);

    public void setPhoneNumber(String text);

    public void setVeteranAddressStateCode(String value);

    public void setVeteranAddressZipCode(String value);

    public void setVeteranAddressProvinceCode(String value);

    public void setVeteranAddressPostalCode(String value);

    public void setZipPlus4(String value);

    public void setAddressTypeCode(AddressType addressType);
    
    public void createVeteranAddress();

    /**
     * Expire current address
     *
     */
    public void expireVeteranAddress();

    public void updateVeteranAddress();

    /**
     * Return Current Address updated address date
     */
    public Date getVeteranAddressUpdatedDate();

    /**
     * Return Incoming Address updated address date
     */
    public Date getAddressUpdatedDate();
    
    /**
     * Set the address last updated date
     */
    public void setAddressUpdatedDate(Date date);

    /**
     * Return Incoming Address State code
     */
    public String getAddressStateCode();

    /**
     * Return Incoming Address Zip Code
     * @return zipcode
     */
    public String getAddressZipCode();

    /**
     * 
     * @return zip code for the on file record.
     */
    public String getPristineAddressZipCode();
    
    /**
     * 
     * @return updated date of address paramter
     */  
    public Date getUpdatedDate(Address address);
    
    public String getPOAAddressLineOne();
    public String getPOACity();
    public String getPOAAddressStateCode();
    public String getPOAAddressZipCode();
    public String getPOAAddressProvince();
    public String getPOAAddressPostalCode();
    public String getPOAAddressCountry();
    
    public Address getUpdatedLetterAddress();     

    public boolean isCurrentTemporaryAddressEqualOriginalLetterAddress();    
 
    public boolean isCurrentConfidentialAddressEqualOriginalLetterAddress(); 

    public boolean isIncomingAddressFieldsAllNull();
    
    public boolean  isBadAddressReasonTextRemoved() ;
    
    //CCR11898
    public boolean isVerificationInfoNotNull();
    //CCR11898
    public void setTempAddressFlaginVerificationInfo(boolean tempAdressUpdateMoreRecent);
}
