/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.rule;

// Java classes
import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.lookup.BadAddressReason;
import gov.va.med.esr.common.model.lookup.ComLetterTemplateType;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.persistent.system.SystemParameterDAO;
import gov.va.med.fw.rule.RuleException;
import gov.va.med.fw.service.ServiceException;

import java.math.BigDecimal;
import java.util.Date;

/** Provides methods executed in business rules to create a bulletin
 * and to trigger letter mailing
 * 
 * @author Vu Le
 * @version 1.0
 */
public interface CommunicationsInput extends BaseInput {

    public void trigger623RLetter() throws RuleException;
    
	/** 
	 * Triggers a letter mailingRC
	 * @param letter A letter number to trigger
	 */
	public void triggerLetterMailing(int letter);
    
    public void trigger600CLetter() throws RuleException;

    public void trigger601BLetter() throws RuleException;    
    
    public void trigger620ALetter() throws RuleException;;      
    
    /**
     * Trigger a HEC reviewing bulletin
     */
    public void triggerHECReviewBulletin();    
    
    public void triggerDODDeletionBulletin();
    
    public void triggerSendIneligibleInfoBulletin();
    
    public void triggerPurpleHeartIsNoBulletin();
    
    public void triggerVeteranNeedsVerificationBulletin();
    
    public void triggerPOWYesToNoBulletin();
    
    public void triggerBadAddressNotificationBulletin(BadAddressReason reason);
    
    public void triggerPOWNoToYesBulletin();
    
    public void triggerPOWDiscrepantBulletin();

    public void triggerSSARecordNotMatchBulletin();    
    
    public boolean hasReceivedNotificationOfIneligibleStatus() throws RuleException ;
    
    public String getLetterFileType();
    
    public void setCommunicationStatus(String status) throws RuleException;
    
    public String getPristineRemailStatus();
    
    public void setRemailStatus(String status);
    
    public void setLetterFileType(String fileType) throws RuleException;
    
    public void updateCommunicationInformation();
    
    public boolean isLetterSentToPermanentAddress();
 
    public boolean isLetterSentToTemporaryAddress();
    
    public boolean isLetterSentToConfidentialAddress();
    
    public Date getLetterMailingDate();
    
    public void setLetterAddressEndDate(ImpreciseDate endDate);
    
    public void expireLetterAddress();
    
    public void triggerRemailingOfLetter() throws RuleException;
    
    public Address getLetterMailedToAddress();
    
    public void addCommsErrorMessage(String errorMessage);
          
    public boolean isLetterSentToPOA();
    public BigDecimal getBarcodeId();
    public Long getVersion();
    public BigDecimal getVeteranBarcodeId();
    public String getVeteranFormNumber();
    public Long getVeteranVersion();
    
    public String getCommsLetterFormType();
    
    public void setCommsStatusUpdateDate(Date updateDate);
    public String getCommsComment();
    public void setCommsComment(String comment);
    public boolean isDuplicateMailRequest();
    public boolean isUserOverridingMailRequest();
    public String getLetterType();
    public String getCurrentLetterForm();
    public boolean isLetterFormPreviouslyMailed(String letterFormType) throws RuleException;
    public boolean isLetterFormPreviouslyMailedExcludeMailedStatus(String lettFormType) throws RuleException;
    public boolean hasLetterBeenMailedForSameIncomeYear(String letterFormType) throws RuleException;
    public boolean hasLetterBeenMailedIncludingMailedStatus(String letterFormType) throws RuleException;    
    public String getCommsStatus();
    public void setCommsStatus(String communicationStatus) throws RuleException;
    public boolean isLetterFormPreviouslyMailedDaysAgo(String letterFormType, int daysAgo) throws RuleException;
    public void triggerHecRecord() throws RuleException;    
    public void triggerLetterMailing(String letterFormType) throws RuleException;
    public void start30DaySSNClock() throws RuleException;    
    public void start30DaySSNClock(String subject) throws RuleException;
    public boolean has30DaySSNClockExpired();
    public void start30DayPseudoSSNReasonClock() throws RuleException;
    public void start30DayPseudoSSNVerificationClock() throws RuleException;    
    public void start30DayPseudoSSNReasonClock(String subject) throws RuleException;
    public void start30DayPseudoSSNVerificationClock(String subject) throws RuleException;
    public void cancel30DayPseudoSSNReasonClock() throws RuleException;
    public void cancel30DayPseudoSSNVerificationClock() throws RuleException;    
    public boolean has30DayPseudoSSNReasonClockExpired();
    public boolean has30DayPseudoSSNVerificationClockExpired();
    // CCR 8395 MSDS Clock
    public void cancel72HourMilServQueryClock() throws RuleException;
    //  CCR 8395 MSDS Clock
    public void start72HourMilServQueryClock() throws RuleException;    
    
    public void triggerEGTProcessingStartBulletin();
    
    public void triggerEGTProcessingEndBulletin();
    
    public void triggerEGTProcessingStoppedBulletin();
    
    public String getPristineCommsStatus();
    
    public void setHECRejectReasons();
    
    public void triggerAutoLetter(ComLetterTemplateType type);
    
    public void triggerRemailLetter(ComLetterTemplateType type); 
    
    public void trigger290SSNValidationLetter() throws RuleException;
    
    public void triggerORFZ11NotMatchPersonBulletin() throws RuleException;
    
    public void triggerPersonEligibilityNotVerifiedBulletin() throws RuleException;
    
    public void triggerAppointmentConversionCompleteBulletin() throws RuleException;
    
    public void triggerPersonEligibilityNotVerifiedBulletin(VAFacility facilitySendingMessage) throws RuleException;
    
    public void triggerInconsistantOEFOIFCombatEpisodeData(VAFacility facilitySendingMessage) throws RuleException;
    public void triggerInconsistantOEFOIFCombatEpisodeData(String dfn, VAFacility facilitySendingMessage) throws RuleException;
    public String getMailingAddressTypeCode();
    
    public void triggerVOASpinalCordBulletin() throws RuleException;
    
    public boolean isiMostRecent680NReturnByPostOffice() throws RuleException ;
    public SystemParameterDAO getSystemParameterDAO();
    public void setSystemParameterDAO(SystemParameterDAO systemParameterDAO) ;
    public boolean isHandbookBenefitActive() throws RuleException;
    public boolean has400HSendBefore(Person person)	throws RuleException;
    public boolean isLastHandBookReturnPost(Person person)throws RuleException;
     
    public void triggerHandBookMail(String type)throws RuleException;
    public boolean isHandbookRollOutOver() throws RuleException ;
    
    public void triggerVAPensionToAABulletin();
    public void triggerSCVAPensionTerminateBulletin();
    public void triggerNSCVAPensionTerminateBulletin();
    public void triggerVAPensionToHBBulletin();
    public void triggerSCToVAPensionBulletin();
    public void triggerNSCToVAPensionBulletin();
    
    public boolean isPristinePrimEligCodeLess100();
    public boolean isPristinePrimEligCodeNSCVAPension();
    public boolean isPristinePrimEligCodeNSC();
    public boolean isPristinePrimEligCodeHB();
    public boolean isPristinePrimEligCodeAA();
    
    public boolean isPristinePensionInd();
    public boolean isUpdatedPensionInd();
    public boolean isUpdatedAAInd();
    public boolean isUpdatedHBInd();
    	
    public boolean isProcessingHandbook();
	public void retriggerHandbookForReturnedOrRejected() throws RuleException;
	public boolean hasAny400HTriggerdBefore(Person person)	throws RuleException;

	// CCR 12825
	public String getFinalLetterCode();
	public Date getIvmCaseClosureDate();
	public String getIvmCaseNumber();
	public boolean meetsIvmEligibilityCriteria(Person person) throws RuleException;
	public boolean isIVMFinalLetterActive() throws RuleException;
	
	public void updateMVIOfDODChanges() throws ServiceException, RuleException;
	public void updateMVIOfVerifiedDODChanges() throws ServiceException, RuleException;
}
