/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.rule;

// Java classes
import java.util.Date;

// Library classes

// Framework classes
import gov.va.med.fw.rule.RuleException;

// ESR classes
import gov.va.med.esr.common.model.ee.CatastrophicDisability;
import gov.va.med.esr.common.model.ee.ClinicalDetermination;
import gov.va.med.esr.common.model.ee.MilitarySexualTrauma;
import gov.va.med.esr.common.model.ee.NoseThroatRadium;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.ee.SpinalCordInjury;

/**
 * @author Carlos Ruiz
 * @version 1.0
 */
public interface ClinicalFactorInput extends BaseInput {

    public String getSendingFacilityCode();

    /**
     * @return Returns the noseThroatRadium.
     */
    public NoseThroatRadium getNoseThroatRadium();

    /**
     * @return Returns the catastrophicDisability.
     */
    public CatastrophicDisability getCatastrophicDisability();

    /**
     * @return Returns the clinicalDetermination.
     */
    public ClinicalDetermination getClinicalDetermination();

    public String getMSTIndicator();

    public String getScreenedReportsMSTIndicator();

    public String getNTRStationNumber();

    public String getNTRVerificationMethod();

    public String getCatastrophicDisabilityIndicator();

    public String getVeteranCatastrophicDisabilityIndicator();

    public Date getDateOfDecision();

    public boolean isDiagnosisContained(String code);

    public Date getNTRVerificationDate();

    public Date getDateOfReview();

    public boolean isScoreEmptyForConditionCode();

    public String getSiteDeterminingMST();

    /**
     * Update current veteran's disability Historical information is not
     * implemented
     */
    public void updateVeteranDisability();

    public void updateCDDescriptorsOnly();    
    
    /**
     * Removes the veteran CD.
     */
    public void removeVeteranDisability();

    public Date getCatastrophicReviewDate();

    public Date getVeteranDateOfDecision();

    public String getMethodOfDetermination();

    /**
     * @return
     */
    public String getVeteranMethodOfDetermination();

    /**
     * @return
     */
    public CatastrophicDisability getVeteranCatastrophicDisability();

    /**
     * @return
     */
    public String getDeterminingSite();

    /**
     * @return
     */
    public String getVeteranDeterminingSite();

    /**
     * @return Returns the militarySexualTrauma.
     */
    public MilitarySexualTrauma getMilitarySexualTrauma();

    /**
     * Gets the MilitarySexualTrauma for the person on file.
     */
    public MilitarySexualTrauma getVeteranMST();

    /**
     * @return
     */
    public String getMSTStatus();

    /**
     * @return
     */
    public String getVeteranMSTStatus();

    /**
     * @return
     */
    public boolean isReceivedMSTSameAsVeteran();

    /**
     * Updates the veteran's (on file person) MST with the incoming person's MST
     * information.
     */
    public void updateVeteranMST();

    /**
     * @return
     */
    public Date getMSTStatusChangeDate();

    /**
     * @return
     */
    public Date getVeteranMSTStatusChangedDate();

    /**
     * Return the veteran's current NTR
     */
    public NoseThroatRadium getVeteranNTR();

    /**
     * @return
     */
    public Date getNTRVerificationDateForVeteran();

    /**
     * Updates the Veteran's NTR record to the incoming NTR information.
     */
    public void updateVeteranNTR();

    /**
     * Removes the Veteran's NTR record.
     */
    public void removeVeteranNTR();

    /**
     * Returns true if the received NTR data is different than the Veteran's NTR
     * (pristine person), otherwise returns false. NTR verification date is not
     * used for comparison.
     */
    public boolean isReceivedNTRDataSameAsVeteran();

    public String getPriorCatastrophicDisabilityIndicator()
            throws RuleException;

    /**
     * Obtains the catastrophic disability indicator from the supplied person
     * object
     * 
     * @param person
     * @return string value indicating if catastrophically disabled. Returns "Y"
     *         if yes, "N" if no or if indicator is not set
     */
    public String getCatastrophicDisabilityIndicator(Person person);
    public SpinalCordInjury getVeternSpinalCordInjury(); 


    public void updateVeternSpinalCordInjury(); 
    
    public void updateVeteranNTRFromVOA();
    
    public Date getCDReviewDate(Person person);
    
    public Date getCDDecisionDate(Person person);
    
    public boolean isCDDescriptorDataChanged();
    
    public boolean hasIncomingCDDescriptors();
}