/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.rule;

// Java classes
import java.io.Serializable;
import java.util.Date;

// Library classes

// Framework classes
import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.rule.RuleException;
import gov.va.med.fw.rule.RuleMethod;
import gov.va.med.fw.rule.RuleSession;

// EDB classes

/**
 * This interface serves as a marker base interface for all rule input
 * interfaces in ESR rule package
 * 
 * Project: Common
 * @author DNS   LEV
 * @version 1.0
 */
public interface BaseInput extends RuleMethod, RuleSession, Serializable {
    /** 
     * Returns a person that is pristine from the database and it is 
     * not altered during a rule flow execution's trasaction.
     * 
     * @return A person that is pristine from the database
     */
    public Person getPristinePerson();
    
    /**
     *  Returns a person that is built from incoming data
     * @return A person that comes in from VISTA or HEC
     */
    public Person getIncomingPerson();
    
    /** 
     * Returns a person that is currently being updated in 
     * the rule flow's process
     * 
     * @return A person that is currently being updated
     */
    public Person getResultPerson();
    
   public boolean isDatePrecise( Date input );
   
   public boolean isDatePrecise(ImpreciseDate input); 
   
   /**
    * Determines if the site is a satellite of the other. Note that
    * satellites do not transmit HL7 data.  
    * @param satellite
    * @param parent
    * @return
    */
   public boolean isSatelliteSite(VAFacility satellite, VAFacility parent) throws RuleException;
   
   public EntityKey getEntityKey();
   
   public String getUseCaseName();
   
   public boolean isUpdateFromGUI();
   
   public boolean isSSNValid(String ssn); 
   
   public VAFacility getSendingFacility();
   
   public String getDfn();
   
   // CCR 11457
   public Person getVerifiedAapData() throws RuleException;
   
   public Person getVerifiedSiteData() throws RuleException;
   public Person getUnverifiedSiteData() throws RuleException;
   public Person getMostRecentSiteData() throws RuleException;
   // Code CR 8672 - many issues, this one being that future check must
   // ignore time element   
   public boolean isAfterIgnoreTime(Date date1, Date date2);
   
   public boolean isMessageFromVOA();
   
   public boolean isMessageFromVista();
   
   // CCR 10311
   public boolean isCleanup();
   
   // CCR 8395
   public void setImprovedByMSDS(boolean improvedByMSDS);   
   public boolean isMsdsActive() throws RuleException; 
   public boolean isReconActive()throws RuleException;
}