/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.rule;

// Java classes
import java.util.Date;

// Library classes

// Framework classes
import gov.va.med.fw.rule.RuleException;

// ESR classes
import gov.va.med.esr.common.model.person.Association;
import gov.va.med.esr.common.model.person.Name;

/**
 * @author Carlos Ruiz
 * @version 1.0
 */
public interface AssociationInput extends BaseInput 
{
    public String getRelationshipType();
    public String getPristineRelationshipType();
    
    public String getAssociationType();
    
    public String getOrganizationName();
    public String getPristineOrganizationName();

    public boolean isNameProvided();
    public Name getName();
    public Name getPristineName();
    
    // Association Address properties:
    public String getAddressLineOne();
    public String getPristineAddressLineOne();

    public String getAddressLineTwo();
    public String getPristineAddressLineTwo();
    
    public String getAddressLineThree();
    public String getPristineAddressLineThree();
    
    public String getCity();
    public String getPristineCity();

    public String getCounty();
    public String getPristineCounty();

    public String getAddressStateCode();
    public String getPristineAddressStateCode();
    
    public String getAddressZipCode();
    public String getPristineAddressZipCode();
    
    public String getAddressZipPlus4();
    public String getPristineAddressZipPlus4();
    
    public String getPrimaryPhone();
    public String getPristinePrimaryPhone();
    
    
    public Date getDeactivationDate();
    public Date getpristineDeactivationDate();
    
    public Date getVeteranDateOfBirth();

    public String getAssociationFirstName();
    
    public String getAssociationLastName();
    
    public boolean isAssociationOnFile();
    public boolean isVAGuardianExist();
    
    public Association getResultAssociation();
    
    public Date getAssociationDateTimeLastUpdated();
    
    public Date getAssociationDateTimeLastUpdatedOnFile();  
    
    public void acceptAssociationTypeForTheVeteran();
    public void addNewAssociation();
    public void updateAssociation( String type ) throws RuleException;
    public void deactivateAssociationByType(  ) throws RuleException;
}
