/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.report.data.impl;

import java.util.List;
import java.util.Set;

import org.hibernate.Query;
import org.hibernate.Session;

import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.report.data.QueryCriteria;
import gov.va.med.fw.report.data.ReportDataException;

import gov.va.med.esr.common.model.lookup.ReportFormat;
import gov.va.med.esr.common.model.lookup.WkfCaseType;
import gov.va.med.esr.common.model.report.ReportParameterSet;
import gov.va.med.esr.common.model.report.ReportSetup;
import gov.va.med.esr.common.report.data.CommonCriteria;
import gov.va.med.esr.common.report.data.StandardReportCriteria;

/**
 * @author DNS   KATIKM
 *
 */
public class WorkloadTurnaroundDAOImpl extends
        AbstractStandardReportDataDAOImpl {
    
    private static final long serialVersionUID = -7340332537227379835L;

    protected Query buildQuery(ReportConfiguration config, Session session) throws ReportDataException {

        //Get the query with default from and to date parameters
        Query query = null;
        if (getNameResolver() != null) {
            query = this.getNamedQuery(getNameResolver().getReportName(config),session);
        }
        else {
            query = this.getNamedQuery(session);
        }
    
        //Set in the base class 
        QueryCriteria reportCriteria = config.getQueryCriteria();
        StandardReportCriteria criteria = (StandardReportCriteria)reportCriteria;
        ReportSetup setup = criteria.getReportSetup();
    
        ReportParameterSet parameters = setup != null ? setup.getParameterSet() : null;
        if( parameters == null ) {
            throw new ReportDataException("Missing report parameters in report " + config.getReportID() );
        }
        query.setDate(CommonCriteria.START_DATE, parameters.getFromDate());
        query.setDate(CommonCriteria.END_DATE, parameters.getToDate());
        
        //set functional group
        List functionalGroupIds = getLookupIds(parameters.getFunctionalGroups());
        query.setParameterList("functionalGroupList",functionalGroupIds);
        
        //case types
        Set casTypes = parameters.getWkfCaseTypes();
        List wkfTypeIds = null;
        if (casTypes != null && casTypes.size() > 0) {
        wkfTypeIds = getLookupIds(parameters.getWkfCaseTypes());
        }
        else {
            wkfTypeIds = getLookupIds(WkfCaseType.class);
        }
        query.setParameterList("wkfCaseTypeList",wkfTypeIds);        
		
        //parameters for detaild report
        ReportFormat reportFormat = parameters.getReportFormat(); 
        if (reportFormat != null & reportFormat.getCode().equals(ReportFormat.DETAIL.getCode())){
        	
    		//days
    		Integer days = parameters.getOutlierDays();
    		if (days == null) days = new Integer(0);
    		query.setInteger("days",days.intValue());
    		
            Integer randomRecords = parameters.getRandomNumberOfRecords();
            if (randomRecords != null && randomRecords.intValue() > 0) {
                query.setParameter("ALL","NO"); 
                query.setParameter("randomNumberOfRecords",randomRecords); 
            }
            else {
                query.setParameter("ALL","ALL"); 
                query.setParameter("randomNumberOfRecords",new Integer(0)); 
            }
        }
                
        return query;
    }
}
