/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.report.data.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import org.hibernate.Query;
import org.hibernate.Session;

import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.model.lookup.AbstractLookup;
import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.report.data.QueryCriteria;
import gov.va.med.fw.report.data.ReportDataException;

import gov.va.med.esr.common.model.lookup.AACIndicator;
import gov.va.med.esr.common.model.lookup.WkfCaseStatusType;
import gov.va.med.esr.common.model.lookup.WkfCaseType;
import gov.va.med.esr.common.model.report.ReportLookupParameter;
import gov.va.med.esr.common.model.report.ReportParameterSet;
import gov.va.med.esr.common.model.report.ReportSetup;
import gov.va.med.esr.common.model.report.ReportVBAQueryStatus;
import gov.va.med.esr.common.report.data.CommonCriteria;
import gov.va.med.esr.common.report.data.StandardReportCriteria;

/**
 * @author DNS   KATIKM
 *
 */
public class WorkloadStatisticsDAOImpl extends
		AbstractStandardReportDataDAOImpl {
	
   private static final long serialVersionUID = 4629070864320556932L;

   public void preDataRetrieval( ReportConfiguration config ) throws ReportDataException {
	      
	      QueryCriteria reportCriteria = config.getQueryCriteria();
		  StandardReportCriteria criteria = (StandardReportCriteria)reportCriteria;
		  ReportSetup setup = criteria.getReportSetup();
		  ReportParameterSet parameters = setup.getParameterSet();
			
	      if( reportCriteria instanceof StandardReportCriteria ) {
	         criteria.setStartDate( this.getDate( config, true ) );
	         criteria.setEndDate( this.getDate( config, false ) );
	         
	 		Integer days = parameters.getOutlierDays();
			if (days == null) days = new Integer(0);
			
	         criteria.setExceedXDays(days.toString());
	      }
   }
	   
	protected Query buildQuery(ReportConfiguration config, Session session) throws ReportDataException {

		//Get the query with default from and to date parameters
		Query query = null;
		if (getNameResolver() != null) {
			query = this.getNamedQuery(getNameResolver().getReportName(config),session);
		}
		else {
			query = this.getNamedQuery(session);
		}
	
		//Set in the base class	
		QueryCriteria reportCriteria = config.getQueryCriteria();
		StandardReportCriteria criteria = (StandardReportCriteria)reportCriteria;
		ReportSetup setup = criteria.getReportSetup();
	
		ReportParameterSet parameters = setup != null ? setup.getParameterSet() : null;
		if( parameters == null ) {
			throw new ReportDataException("Missing report parameters in report " + config.getReportID() );
		}
		query.setDate(CommonCriteria.START_DATE, parameters.getFromDate());
		query.setDate(CommonCriteria.END_DATE, parameters.getToDate());
		
		//set functional group
		List functionalGroupIds = getLookupIds(parameters.getFunctionalGroups());
		query.setParameterList("functionalGroupList",functionalGroupIds);
        
		//set case statuses
        Set caseStatusTypes = parameters.getWkfCaseStatusTypes();
        List wkfStatusIds = null;
        if (caseStatusTypes != null && caseStatusTypes.size() > 0){
            wkfStatusIds = getLookupIds(parameters.getWkfCaseStatusTypes());
        }
        else {
            wkfStatusIds = getLookupIds(WkfCaseStatusType.class);
        }		
		query.setParameterList("wkfCaseStatusList",wkfStatusIds);
		
        //case types
        Set casTypes = parameters.getWkfCaseTypes();
        List wkfTypeIds = null;
        if (casTypes != null && casTypes.size() > 0) {
            wkfTypeIds = getLookupIds(parameters.getWkfCaseTypes());
        }
        else {
            wkfTypeIds = getLookupIds(WkfCaseType.class);
        }
        query.setParameterList("wkfCaseTypeList",wkfTypeIds);
        
		//days
		Integer days = parameters.getOutlierDays();
		if (days == null) days = new Integer(0);
		query.setInteger("days",days.intValue());
		return query;
	}
}
