/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.esr.common.report.data.impl;

import java.util.List;
import java.util.ArrayList;

import org.hibernate.Query;
import org.hibernate.Hibernate;
import org.hibernate.Session;

import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.report.data.QueryCriteria;
import gov.va.med.fw.report.data.ReportDataException;

import gov.va.med.esr.common.model.lookup.ComLetterTemplateType;
import gov.va.med.esr.common.report.data.StandardReportCriteria;
import gov.va.med.esr.common.model.lookup.ReportEEDWeeklyType;

/**
 * @author DNS   LEV
 *
 */
public class WeeklyReportDAOImpl extends ParamSubstitutionDAOImpl {

   /**
    * An instance of serialVersionUID
    */
   private static final long serialVersionUID = 7579882040234259862L;

   /**
    * A default constructor 
    */
   public WeeklyReportDAOImpl() {
      super();
   }

   /**
    * @see gov.va.med.fw.report.data.ReportDataDAO#getRecords(gov.va.med.fw.report.ReportConfiguration, int, int)
    */
   public List getRecords(ReportConfiguration config, int firstRecord, int maxRecord) throws ReportDataException {
      List results = new ArrayList();
      QueryCriteria reportCriteria = config.getQueryCriteria();
      if( reportCriteria instanceof StandardReportCriteria ) {
         
         // Get a criteria
         StandardReportCriteria criteria = (StandardReportCriteria)reportCriteria;
         String alias = criteria.getSubReportName();
         if( ReportEEDWeeklyType.AAC_ENROLLMENT_LETTERS.getAlias().equals( alias ) ) {
            String[] formNames = new String[] {
                  ComLetterTemplateType.FORM_NUMBER_600C.getCode(),
                  ComLetterTemplateType.FORM_NUMBER_600D.getCode(),
                  ComLetterTemplateType.FORM_NUMBER_604A.getCode(),
                  ComLetterTemplateType.FORM_NUMBER_604B.getCode(),
                  ComLetterTemplateType.FORM_NUMBER_623A.getCode(),
                  ComLetterTemplateType.FORM_NUMBER_630A.getCode(),
                  ComLetterTemplateType.FORM_NUMBER_630B.getCode(),
                  ComLetterTemplateType.FORM_NUMBER_630C.getCode(),
                  ComLetterTemplateType.FORM_NUMBER_630D.getCode()
            };
            for( int i=0; i<formNames.length; i++) {
               criteria.addCriterion( "formName", formNames[i] );
               List records = super.getRecords(config, firstRecord, maxRecord );
               
               results.addAll( records );
            }
         }
         else {
            results = super.getRecords(config, firstRecord, maxRecord);
         }
      }
      return results;
   }
   
   /**
    * @see gov.va.med.esr.common.report.data.MSTReportDataDAO#buildMSTStatusCriteria(gov.va.med.fw.report.ReportConfiguration)
    */
   protected Query buildQuery(ReportConfiguration config, Session session ) throws ReportDataException {
   
      Query query = super.buildQuery( config, session );
      QueryCriteria criteria = config.getQueryCriteria();
      if( criteria.getCriteria().containsKey("formName") ) {
         String formName = (String)criteria.getCriteria().get("formName" );
         query.setParameter( "formName", formName, Hibernate.STRING );
      }
      return query;
   }
}