/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.report.data.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.Query;

import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.report.data.QueryCriteria;
import gov.va.med.fw.report.data.ReportDataException;
import gov.va.med.fw.util.StringUtils;

import gov.va.med.esr.common.model.lookup.ReportExceptionType;
import gov.va.med.esr.common.model.report.ReportParameterSet;
import gov.va.med.esr.common.model.report.ReportSetup;
import gov.va.med.esr.common.report.data.CommonCriteria;
import gov.va.med.esr.common.report.data.StandardReportCriteria;

/**
 * QM3 Reports Data DAO.
 * 
 * @author Muddaiah Ranga
 *
 */
public class QM27ReportDataDAOImpl extends ParamSubstitutionDAOImpl {

    private static final long serialVersionUID = 1178123948624532738L;

    /* 
     * @see gov.va.med.fw.report.data.ReportDataDAO#preDataRetrieval(gov.va.med.fw.report.ReportConfiguration)
     */
    public void preDataRetrieval( ReportConfiguration config ) throws ReportDataException {
        QueryCriteria reportCriteria = config.getQueryCriteria();

        if( reportCriteria instanceof StandardReportCriteria ) {
           StandardReportCriteria criteria = (StandardReportCriteria)reportCriteria;
           ReportSetup setup = criteria.getReportSetup();
           ReportParameterSet parameters = setup != null ? setup.getParameterSet() : null;
           if( parameters == null ) {
                throw new ReportDataException("Missing report parameters in report " + config.getReportID() );
            }
           Integer batchNumber = parameters.getBatchNumber();
           if(batchNumber != null) {
               criteria.addCriterion(CommonCriteria.BATCH_NUMBER,batchNumber.toString());
           }
           ReportExceptionType exceptionType = parameters.getExceptionType();
           if(exceptionType != null) {
               criteria.addCriterion(CommonCriteria.EXCEPTION_TYPE,exceptionType.getDescription());
           }
        }
    }
    
    protected Query buildQuery( ReportConfiguration config, Session session ) throws ReportDataException {
        
        QueryCriteria reportCriteria = config.getQueryCriteria();
        Query query = null;

        if( reportCriteria instanceof StandardReportCriteria ) {

            // Get a named query
            query = this.getNamedQuery( session );
            
            // Get a criteria
            StandardReportCriteria criteria = (StandardReportCriteria)reportCriteria;
            ReportSetup setup = criteria.getReportSetup();
            ReportParameterSet parameters = setup != null ? setup.getParameterSet() : null;
            if( parameters == null ) {
                throw new ReportDataException("Missing report parameters in report " + config.getReportID() );
            }

            Integer batchNumber = parameters.getBatchNumber();
            if(batchNumber == null) {
                throw new ReportDataException( "Missing Batch Number in report " + config.getReportID() );
            }
            
            query.setInteger(CommonCriteria.BATCH_NUMBER, batchNumber.intValue());
            
            ReportExceptionType exceptionType = parameters.getExceptionType();
            if(exceptionType != null) {
                if(StringUtils.equals(exceptionType.getCode(),ReportExceptionType.ALL.getCode())) {
                    query.setString(CommonCriteria.IS_ALL,CommonCriteria.IS_ALL);
                    query.setString(CommonCriteria.IS_NULL,CommonCriteria.IS_ALL);
                    query.setString(CommonCriteria.IS_NOT_NULL,CommonCriteria.IS_ALL);
                    query.setString(CommonCriteria.EXCEPTION_TYPE,"0");
                } else {
                    query.setString(CommonCriteria.IS_ALL,CommonCriteria.IS_NOT_NULL);
                    query.setString(CommonCriteria.IS_NULL,CommonCriteria.IS_NOT_NULL);
                    query.setString(CommonCriteria.IS_NOT_NULL,CommonCriteria.IS_NOT_NULL);
                    query.setString(CommonCriteria.EXCEPTION_TYPE,exceptionType.getCode());
                }
            } else {
                query.setString(CommonCriteria.IS_ALL,CommonCriteria.IS_NULL);
                query.setString(CommonCriteria.IS_NULL,CommonCriteria.IS_NULL);
                query.setString(CommonCriteria.IS_NOT_NULL,CommonCriteria.IS_NULL);
                query.setString(CommonCriteria.EXCEPTION_TYPE,"0");
            }
        }
        return query;
    }
}