/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.esr.common.report.data.impl;

// Java classes
import java.util.Map;
import java.util.ArrayList;

// Library classes

// Framework classes
import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.report.ReportException;
import gov.va.med.fw.report.data.ReportData;
import gov.va.med.fw.report.data.ReportDataService;
import gov.va.med.fw.report.jasperreport.data.JasperReportData;
import gov.va.med.fw.service.AbstractComponent;

// ESR classes

/**
 * Provides methods to obtain OPP extract file data.  OPP data is passed into
 * a report service to generate a report so this data service doen't need to 
 * collaborate with any DAO to query data.   
 *
 * Project: Common</br>
 * Created on: 4:46:34 PM </br>
 *
 * @author DNS   LEV
 */
public class OPPReportDataServiceImpl extends AbstractComponent implements ReportDataService {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 6206574042186070516L;

	/**
	 * A default constructor
	 */
	public OPPReportDataServiceImpl() {
		super();
	}

	public ReportData requestReportData(ReportConfiguration configuration) throws ReportException {
		
		// Get a report data that is encapsulated in a query criteria
		Map criteria = configuration.getQueryCriteria().getCriteria();
		
		// Create an OPP report data
		ArrayList reportData = new ArrayList();
		reportData.add( criteria );
		
		// Returns data to generate a report
		return new JasperReportData( reportData );
	}
}
