/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.esr.common.report.data.impl;

// Library classes
import org.hibernate.Query;
import org.hibernate.Session;

// Framework classes
import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.report.data.ReportDataException;

/**
 * This dao impl class doesn't set any parameters in the query.
 * Some of the queries doesn't need any parameters
 * @author DNS   kullav
 * 
 */
public class NonParamsReportDAOImpl extends AbstractStandardReportDataDAOImpl {   

   
	private static final long serialVersionUID = 420530701710477789L;

/**
    * A default constructor 
    */
   public NonParamsReportDAOImpl() {
      super();
   }
  
  /**
   * This method returns query object with setting any parameters.
   * Some of the queries doesn't need any parameters.
   * @param config
   * @return query
   */
   protected Query buildQuery(ReportConfiguration config, Session session ) throws ReportDataException {
   
      Query query = getNamedQuery( session );
      return query;
   }
  
}