/**
 * 
 */
package gov.va.med.esr.common.report.data.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import org.hibernate.Query;
import org.hibernate.Session;

import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.report.data.QueryCriteria;
import gov.va.med.fw.report.data.ReportDataException;

import gov.va.med.esr.common.model.lookup.ReportFacilityDisplayBy;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.report.ReportFacility;
import gov.va.med.esr.common.model.report.ReportParameterSet;
import gov.va.med.esr.common.model.report.ReportSetup;
import gov.va.med.esr.common.report.data.CommonCriteria;
import gov.va.med.esr.common.report.data.StandardReportCriteria;

/**
 * @author DNS   KATIKM
 *
 */
public class IV5ReportDataDAOImpl extends AbstractStandardReportDataDAOImpl {
    private static final long serialVersionUID = -7314500493075026550L;

    protected Query buildQuery(ReportConfiguration config, Session session) throws ReportDataException {

        Query query = null;
        query = this.getNamedQuery(session);
        
        //Set in the base class 
        QueryCriteria reportCriteria = config.getQueryCriteria();
        StandardReportCriteria criteria = (StandardReportCriteria)reportCriteria;
        ReportSetup setup = criteria.getReportSetup();
    
        ReportParameterSet parameters = setup != null ? setup.getParameterSet() : null;
        if( parameters == null ) {
            throw new ReportDataException("Missing report parameters in report " + config.getReportID() );
        }
        query.setDate(CommonCriteria.START_DATE, parameters.getFromDate());
        query.setDate(CommonCriteria.END_DATE, parameters.getToDate());
                
        Set reportFacilities = parameters.getFacilities();
        if(reportFacilities == null || reportFacilities.isEmpty()) {
            List facilities = new ArrayList();
            facilities.add("FACILITY");
            query.setParameterList( "facilityNameList", facilities);
            query.setString("ALL","ALL");
        } else {
            query.setParameterList( "facilityNameList", this.getFacilitityNameList(reportFacilities));
            query.setString("ALL","NO");
        }

        return query;
    }

    private List getFacilitityNameList(Set facilities) {
        Iterator i = facilities != null ? facilities.iterator() : null;
        ArrayList list = new ArrayList();
        String HEC = VAFacility.CODE_HEC.getCode();
        while( i != null && i.hasNext() ) {
            ReportFacility rFacility = (ReportFacility)i.next();
            if(rFacility != null) {
                VAFacility facility = (VAFacility)rFacility.getLookup();
                if (HEC.equals(facility.getStationNumber())) {
                    list.add("HEC-"+facility.getStationNumber());
                }
                else {
                    list.add("VAMC-"+facility.getStationNumber());
                }
            }
        }
        return list;
    }
}
