/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.esr.common.report.data.impl;

// Library classes
import org.hibernate.Query;
import org.hibernate.Session;

// Framework classes
import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.report.data.QueryCriteria;
import gov.va.med.fw.report.data.ReportDataException;
import gov.va.med.fw.util.StringUtils;

// ESR classes

import gov.va.med.esr.common.model.report.ReportSetup;
import gov.va.med.esr.common.model.report.ReportParameterSet;
import gov.va.med.esr.common.model.lookup.AckType;
import gov.va.med.esr.common.model.lookup.MessageType;
import gov.va.med.esr.common.model.lookup.StandardReport;
import gov.va.med.esr.common.report.data.CommonCriteria;
import gov.va.med.esr.common.report.data.StandardReportCriteria;

/**
 *
 * Project: Common</br> 
 *
 * @author DNS   KULLAV
 */
public class HL7MessageReportDataDAOImpl extends ParamSubstitutionDAOImpl {


	private static final long serialVersionUID = -2285009104853528621L;

	public static final String[] INBOUND_SITE_MESSAGES = new String[]{ 
			MessageType.CODE_ORUZ07_TO_ESR.getCode(), 
			 MessageType.CODE_QRYZ10_TO_ESR.getCode(),
			 MessageType.CODE_QRYZ11_TO_ESR.getCode() 
			  };
	 
	public static final String[] INBOUND_VBA_MESSAGES = new String[]{ 
			MessageType.CODE_ORUZ05_TO_ESR.getCode(), 
			 MessageType.CODE_ORFZ11_TO_ESR.getCode(),
			 MessageType.CODE_ORUZ11_TO_ESR.getCode(),
			 MessageType.CODE_ORUZ12_TO_ESR.getCode(),
			 MessageType.CODE_ORUZ13_TO_ESR.getCode()
			 };
	 
	public static final String[] OUTBOUND_SITE_MESSAGES = new String[]{ 
			MessageType.CODE_ORUZ05_TO_SITE.getCode(), 
			 MessageType.CODE_ORUZ06_TO_SITE.getCode(),
			 MessageType.CODE_ORUZ10_TO_SITE.getCode(),
			 MessageType.CODE_ORUZ11_TO_SITE.getCode(),
			 MessageType.CODE_ORFZ10_TO_SITE.getCode(),
			 MessageType.CODE_ORFZ11_TO_SITE.getCode()
			 };
	 
	public static final String[] ACK_TYPES = new String[]{ 
			AckType.CODE_AA.getCode(), 
			 AckType.CODE_AE.getCode(),
			 AckType.CODE_AR.getCode()
			};
	
	
	 
	/**
	 * A default constructor
	 */
	public HL7MessageReportDataDAOImpl() {
		super();
	}
	
	public void preDataRetrieval(ReportConfiguration config)
		throws ReportDataException {
		super.preDataRetrieval(config);
		QueryCriteria reportCriteria = config.getQueryCriteria();
		
			if (reportCriteria instanceof StandardReportCriteria) {
				StandardReportCriteria criteria = (StandardReportCriteria) reportCriteria;
				ReportSetup setup = criteria.getReportSetup();
				ReportParameterSet parameters = setup != null ? setup
						.getParameterSet() : null;
				if (parameters == null) {
					throw new ReportDataException(
							"Missing report parameters in report "
									+ config.getReportID());
				}	
				criteria.setStartDate(this.getDate(config, true));
				criteria.addCriterion(CommonCriteria.REPORT_TITLE, setup.getReport().getName());
//				if(StringUtils.deleteWhitespace(StandardReport.CODE_QM_28.getCode()).equals(config.getReportName()))
//					criteria.addCriterion(CommonCriteria.REPORT_TITLE, setup);
//				else if(StringUtils.deleteWhitespace(StandardReport.CODE_QM_9.getCode()).equals(config.getReportName()))
//					criteria.addCriterion(CommonCriteria.REPORT_TITLE, QM9_TITLE);
//				else if(StringUtils.deleteWhitespace(StandardReport.CODE_QM_12.getCode()).equals(config.getReportName()))
//					criteria.addCriterion(CommonCriteria.REPORT_TITLE, QM12_TITLE);		
			}
	}	 

	/**
	 * @see gov.va.med.fw.report.data.hibernate.HibernateReportDataDAO#buildQuery(gov.va.med.fw.report.ReportConfiguration)
	 */
	protected Query buildQuery( ReportConfiguration config,Session session) throws ReportDataException {
		
		QueryCriteria reportCriteria = config.getQueryCriteria();
		Query query = null;

		if( reportCriteria instanceof StandardReportCriteria ) {

			// Get a named query
			query = this.getNamedQuery(session);
			
			// Get a criteria
			StandardReportCriteria criteria = (StandardReportCriteria)reportCriteria;
			ReportSetup setup = criteria.getReportSetup();
			ReportParameterSet parameters = setup != null ? setup.getParameterSet() : null;
			if(StringUtils.deleteWhitespace(StandardReport.CODE_QM_28.getCode()).equals(config.getReportName()))
				query.setParameterList(CommonCriteria.MESSAGE_TYPES,INBOUND_SITE_MESSAGES );
			else if(StringUtils.deleteWhitespace(StandardReport.CODE_QM_29.getCode()).equals(config.getReportName()))
				query.setParameterList(CommonCriteria.MESSAGE_TYPES,INBOUND_VBA_MESSAGES );
			else if(StringUtils.deleteWhitespace(StandardReport.CODE_QM_30.getCode()).equals(config.getReportName()))
				query.setParameterList(CommonCriteria.MESSAGE_TYPES,OUTBOUND_SITE_MESSAGES );				
			query.setDate( CommonCriteria.START_DATE, (parameters != null) ? parameters.getFromDate() : null);
		}
		return query;
	}	
}