package gov.va.med.esr.common.report.data.impl;

import gov.va.med.esr.common.model.report.ReportMessageError;
import gov.va.med.esr.common.model.report.ReportMessageType;
import gov.va.med.esr.common.model.report.ReportParameterSet;
import gov.va.med.esr.common.model.report.ReportSetup;
import gov.va.med.esr.common.report.data.CommonCriteria;
import gov.va.med.esr.common.report.data.StandardReportCriteria;
import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.report.data.QueryCriteria;
import gov.va.med.fw.report.data.ReportDataException;

import java.util.Set;

import org.hibernate.Query;
import org.hibernate.Session;

/**
 * HL7ErrorReportDataDAOImpl
 * @created Oct 11, 2006 1:53:59 PM
 * @author DNS   MANSOG
 */
public class HL7ErrorReportDataDAOImpl extends ParamSubstitutionDAOImpl {

    private static final long serialVersionUID = -1986182813327815652L;
    private String title     = "HL7 Error Report";
    private String direction = null;
    private String queryNameAE = "hl7AEErrorReport.Summary";
    private String queryNameAR = "hl7ARErrorReport.Summary";
    private String queryNameAEandAR = "hl7AEandARErrorReport.Summary";
    
    // ESR 3.1 CCR8131 -- allow detailed report query to be used when selected
    private boolean summary = true;
    
    /**
     * @see gov.va.med.esr.common.report.data.impl.ParamSubstitutionDAOImpl#buildQuery(gov.va.med.fw.report.ReportConfiguration,
     *      org.hibernate.Session)
     */
    protected Query buildQuery(ReportConfiguration config, Session session) throws ReportDataException {
        //Added below code to fix the CR_7424, when the user select 'AE' queryNameAE is used and queryNameAR for 'AR' and queryNameAEandAR for 'both'
        QueryCriteria reportCriteria = config.getQueryCriteria();
        Query query = null;
        
        if (reportCriteria instanceof StandardReportCriteria) {
          
          // CCR8131 -- allow detailed report query to be built as well:
          if (isSummary()) {
              StandardReportCriteria criteria = (StandardReportCriteria) reportCriteria;
              ReportSetup setup = criteria.getReportSetup();
              ReportParameterSet parameters = setup != null ? setup.getParameterSet() : null;
  
              Set messageErrors = (parameters != null) ? parameters.getMessageErrors() : null;
              if (messageErrors != null && messageErrors.size() == 1) {
                  ReportMessageError messageErrorType = (ReportMessageError)messageErrors.iterator().next();
                  if(messageErrorType.getMessageError().getCode().equalsIgnoreCase("AE")){
                      super.setQueryName(queryNameAE);
                  }else if(messageErrorType.getMessageError().getCode().equalsIgnoreCase("AR")){
                      super.setQueryName(queryNameAR);
                  }
              }else if(messageErrors != null && messageErrors.size() == 2){
                  super.setQueryName(queryNameAEandAR);
              }
              // End of code for CR_7424
           }
          
           query = super.buildQuery(config, session);
            if (direction != null) {
                query.setString(CommonCriteria.DIRECTION, direction);
            }
        }
        return query;
    }

    /**
     * @see gov.va.med.esr.common.report.data.impl.ParamSubstitutionDAOImpl#preDataRetrieval(gov.va.med.fw.report.ReportConfiguration)
     */
    public void preDataRetrieval(ReportConfiguration config) throws ReportDataException {
        super.preDataRetrieval(config);
        QueryCriteria reportCriteria = config.getQueryCriteria();
        if (reportCriteria != null) {
            reportCriteria.addCriterion(CommonCriteria.REPORT_TITLE, title);
        }
        if (reportCriteria instanceof StandardReportCriteria) {
            StandardReportCriteria criteria = (StandardReportCriteria) reportCriteria;
            ReportSetup setup = criteria.getReportSetup();
            ReportParameterSet parameters = setup != null ? setup.getParameterSet() : null;

            Set messageTypes = (parameters != null) ? parameters.getMessageTypes() : null;
            if (messageTypes != null && messageTypes.size() > 0) {
                ReportMessageType msgType = (ReportMessageType) messageTypes.iterator().next();
                criteria.addCriterion(CommonCriteria.MESSAGE_TYPE, msgType.getLookup().getCode());
            }
        }

    }

    /**
     * @return Returns the title.
     */
    public String getTitle() {
        return title;
    }

    /**
     * @param title
     *            The title to set.
     */
    public void setTitle(String title) {
        this.title = title;
    }

    /**
     * @return Returns the direction.
     */
    public String getDirection() {
        return direction;
    }

    /**
     * @param direction
     *            The direction to set.
     */
    public void setDirection(String direction) {
        this.direction = direction;
    }

    public String getQueryNameAE() {
        return queryNameAE;
    }

    public void setQueryNameAE(String queryNameAE) {
        this.queryNameAE = queryNameAE;
    }

    public String getQueryNameAR() {
        return queryNameAR;
    }

    public void setQueryNameAR(String queryNameAR) {
        this.queryNameAR = queryNameAR;
    }

    public String getQueryNameAEandAR() {
        return queryNameAEandAR;
    }

    public void setQueryNameAEandAR(String queryNameAEandAR) {
        this.queryNameAEandAR = queryNameAEandAR;
    }

    public boolean isSummary() {
      return summary;
    }

    public void setSummary(boolean summary) {
      this.summary = summary;
    }
        
}
