package gov.va.med.esr.common.report.data.impl;

import gov.va.med.esr.common.model.lookup.ReportDetailBy;
import gov.va.med.esr.common.model.lookup.ReportFormat;
import gov.va.med.esr.common.model.report.ReportEnrollmentOverrideReason;
import gov.va.med.esr.common.model.report.ReportParameterSet;
import gov.va.med.esr.common.model.report.ReportPersonMergeStatus;
import gov.va.med.esr.common.model.report.ReportSetup;
import gov.va.med.esr.common.model.report.ReportUser;
import gov.va.med.esr.common.report.data.CommonCriteria;
import gov.va.med.esr.common.report.data.StandardReportCriteria;
import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.report.data.QueryCriteria;
import gov.va.med.fw.report.data.ReportDataException;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import org.hibernate.Query;
import org.hibernate.Session;

public class EED9ReportDataDAOImpl extends AbstractStandardReportDataDAOImpl {
    
    private static final long serialVersionUID = 3088224483552449071L;

    protected Query buildQuery( ReportConfiguration config, Session session ) throws ReportDataException {
        
        QueryCriteria reportCriteria = config.getQueryCriteria();
        Query query = null;

        if( reportCriteria instanceof StandardReportCriteria ) {

            // Get a named query
            query = this.getNamedQuery( session );
            
            // Get a criteria
            StandardReportCriteria criteria = (StandardReportCriteria)reportCriteria;
            ReportSetup setup = criteria.getReportSetup();
            ReportParameterSet parameters = setup != null ? setup.getParameterSet() : null;
            if( parameters == null ) {
                throw new ReportDataException("Missing report parameters in report " + config.getReportID() );
            }

            Date startDate = parameters.getFromDate();
            if(startDate == null) {
                throw new ReportDataException( "Missing Start Date in report " + config.getReportID() );
            }
            
            Date endDate = parameters.getToDate();
            if(endDate == null) {
                throw new ReportDataException( "Missing End Date in report " + config.getReportID() );
            }
            
            query.setDate(CommonCriteria.START_DATE, startDate);
            query.setDate(CommonCriteria.END_DATE,endDate);
            
            Set enrollmentOverrideReasons = parameters.getEnrollmentOverrideReasons();
           	if (enrollmentOverrideReasons.isEmpty()) {
                if (ReportFormat.DETAIL.getName().equals(parameters.getReportFormat().getCode())){
                	ArrayList listComps = new ArrayList();
                	listComps.add("");
                	query.setParameterList("internalEnrollmentOverrideReasons", listComps);
                	
                	query.setString(CommonCriteria.IS_ALL,"all");
                }
           	}
           	else {
                Iterator iter = enrollmentOverrideReasons.iterator();
                ArrayList listComps = new ArrayList();
                while (iter.hasNext()) {
                	ReportEnrollmentOverrideReason comp = (ReportEnrollmentOverrideReason)iter.next();
                	String code = comp.getEnrollmentOverrideReason().getCode();
                	listComps.add(code);
                }
                query.setParameterList("internalEnrollmentOverrideReasons", listComps);
                
                if (ReportFormat.DETAIL.getName().equals(parameters.getReportFormat().getCode())){
                	query.setString(CommonCriteria.IS_ALL,"notAll");
                }
           	}
           	
            //Optional fields for Detailed report
            if (ReportFormat.DETAIL.getName().equals(parameters.getReportFormat().getCode())){
            
            	if (ReportDetailBy.LAS.getCode().equals(parameters.getDetailBy().getCode())) {
            	
	            	Set reportUsers = parameters.getUsers();
	            
		            if (reportUsers != null && reportUsers.isEmpty()==false) {
		            	List userIds = new ArrayList();
		            	
		            	Iterator iter = reportUsers.iterator();
		            	while(iter.hasNext()) {
		            		ReportUser reportuser = (ReportUser)iter.next();
		            		String userId = reportuser.getUser().getUserCredentials().getUserID();
		            		userIds.add(userId);
		            	}
		            	if (userIds.isEmpty()) {
		            		userIds.add("");
		            	}
		            	query.setParameterList("recordModifiedBy", userIds);
		            	query.setString("is_user_all","notAll");
		            }
		            else {
		            	List userIds = new ArrayList();
		            	userIds.add("");
		            	query.setParameterList("recordModifiedBy", userIds);
		            	query.setString("is_user_all","all");
		            }
		            
            	}
            }
        }
        return query;
    }
    
}