package gov.va.med.esr.common.report.data.impl;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import org.hibernate.Query;
import org.hibernate.Session;

import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.report.data.QueryCriteria;
import gov.va.med.fw.report.data.ReportDataException;
import gov.va.med.fw.util.StringUtils;

import gov.va.med.esr.common.model.lookup.EnrollmentStatus;
import gov.va.med.esr.common.model.lookup.ReportFacilityDisplayBy;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.report.ReportEnrollmentStatus;
import gov.va.med.esr.common.model.report.ReportFacility;
import gov.va.med.esr.common.model.report.ReportParameterSet;
import gov.va.med.esr.common.model.report.ReportSetup;
import gov.va.med.esr.common.model.report.ReportUser;
import gov.va.med.esr.common.report.data.CommonCriteria;
import gov.va.med.esr.common.report.data.StandardReportCriteria;

/**
 * EED1 Reports Data DAO.
 * 
 * @author Muddaiah Ranga
 *
 */
public class EED19ReportDataDAOImpl extends AbstractStandardReportDataDAOImpl {


	protected Query buildQuery( ReportConfiguration config, Session session ) throws ReportDataException {

		QueryCriteria reportCriteria = config.getQueryCriteria();
		Query query = null;

		if( reportCriteria instanceof StandardReportCriteria ) {

			// Get a named query
			query = this.getNamedQuery( session );
			String[] params = query.getNamedParameters();
			// Get a criteria
			StandardReportCriteria criteria = (StandardReportCriteria)reportCriteria;
			ReportSetup setup = criteria.getReportSetup();
			ReportParameterSet parameters = setup != null ? setup.getParameterSet() : null;
			if( parameters == null ) {
				throw new ReportDataException("Missing report parameters in report " + config.getReportID() );
			}

			Date startDate = parameters.getFromDate();
			if(startDate == null) {
				throw new ReportDataException( "Missing Start Date in report " + config.getReportID() );
			}
			query.setDate(CommonCriteria.START_DATE, startDate);

			boolean isDetailedReport = config.getReportOutputName().indexOf("Detailed") > 0;

			if (isDetailedReport) {
				Date endDate = parameters.getToDate();
				if(endDate == null) {
					throw new ReportDataException( "Missing End Date in report " + config.getReportID() );
				}
				query.setDate(CommonCriteria.END_DATE, endDate);


				Set reportUsers = parameters.getUsers();

				if (reportUsers != null && reportUsers.isEmpty()==false) {
					List userIds = new ArrayList();

					Iterator iter = reportUsers.iterator();
					while(iter.hasNext()) {
						ReportUser reportuser = (ReportUser)iter.next();
						String userId = reportuser.getUser().getUserCredentials().getUserID();
						userIds.add(userId);
					}
					if (userIds.isEmpty()) {
						userIds.add("0");
					}
					query.setParameterList("recordsCreatedBy", userIds);
					query.setString(CommonCriteria.IS_ALL,"notAll");
				}
				else {
					List userIds = new ArrayList();
					userIds.add("");
					query.setParameterList("recordsCreatedBy", userIds);
					query.setString(CommonCriteria.IS_ALL,"all");
				}
			}
		}

		return query;
	}


}