/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.esr.common.report.data.impl;

// Java classes

// Library classes

// Framework classes
import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.report.data.ReportDataDAO;
import gov.va.med.fw.report.data.ReportDataIterator;
import gov.va.med.fw.report.jasperreport.data.JasperReportDataService;

// ESR classes

/**
 * Provides methods to obtain EED10 report data.  The ReportDataIterator must be configured
 * to execute the query fewer times for this report since peformance is an issue. 
 *
 * Project: Common</br>
 *
 * @author DNS   GALLAS
 */
public class EED10ReportDataServiceImpl extends JasperReportDataService {

	/**
	 * An instance of serialVersionUID
	 */
    private static final long serialVersionUID = -7234581306072316944L;
    
    /**
     * EED10 size of a result set. 4000 records in a list
     */
    private static final int PAGE_SIZE = 4000;
    
    private int pageSize = PAGE_SIZE;

    /**
	 * A default constructor
	 */
	public EED10ReportDataServiceImpl() {
		super();
	}
    
    /**
     * @param pageSize The pageSize to set.
     */
    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    protected ReportDataIterator getReportDataIterator(ReportDataDAO dao, ReportConfiguration configuration) {
        return new ReportDataIterator( dao, configuration, pageSize );
    }
}
