package gov.va.med.esr.common.report.data.impl;

import gov.va.med.esr.common.model.lookup.ReportFacilityDisplayBy;
import gov.va.med.esr.common.model.report.BaseReportLookupParameter;
import gov.va.med.esr.common.model.report.ReportParameterSet;
import gov.va.med.esr.common.model.report.ReportSetup;
import gov.va.med.esr.common.model.report.ReportUser;
import gov.va.med.esr.common.report.data.CommonCriteria;
import gov.va.med.esr.common.report.data.StandardReportCriteria;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.report.data.QueryCriteria;
import gov.va.med.fw.report.data.ReportDataException;
import gov.va.med.fw.util.StringUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import org.hibernate.Query;
import org.hibernate.Session;

public class Cor1ReportDataDAOImpl extends AbstractStandardReportDataDAOImpl {

    private static final long serialVersionUID = 1186984553660142327L;

    protected Query buildQuery( ReportConfiguration config, Session session ) throws ReportDataException {
        
        QueryCriteria reportCriteria = config.getQueryCriteria();
        Query query = null;

        if( reportCriteria instanceof StandardReportCriteria ) {

            // Get a named query
            query = this.getNamedQuery( session );
            
            // Get a criteria
            StandardReportCriteria criteria = (StandardReportCriteria)reportCriteria;
            ReportSetup setup = criteria.getReportSetup();
            ReportParameterSet parameters = setup != null ? setup.getParameterSet() : null;
            if( parameters == null ) {
                throw new ReportDataException("Missing report parameters in report " + config.getReportID() );
            }

            Date startDate = parameters.getFromDate();
            if(startDate == null) {
                throw new ReportDataException( "Missing Start Date in report " + config.getReportID() );
            }
            
            Date endDate = parameters.getToDate();
            if(endDate == null) {
                throw new ReportDataException( "Missing End Date in report " + config.getReportID() );
            }
            
            query.setDate(CommonCriteria.START_DATE, startDate);
            query.setDate(CommonCriteria.END_DATE,endDate);
            
            List emptyList = new ArrayList();
            emptyList.add("");
            
           	//query.setString("is_reject_all", "all");
        	//query.setParameterList("letterRejectReasons", emptyList);
        	//query.setString("is_error_all", "all");
        	//query.setParameterList("letterErrorTypes", emptyList);
        	
            
            if (parameters.getAllLetterRejectReasons()) {
            	query.setString("is_reject_all", "all");
            	query.setParameterList("letterRejectReasons", emptyList);
            }
            else {
            	query.setString("is_reject_all","notAll");
            	
            	List queryList = new ArrayList();
            	Set rejectReasons = parameters.getLetterRejectReasons();
            	if (rejectReasons.size() > 0) {
	            	Iterator iter = rejectReasons.iterator();
	            	while (iter.hasNext()) {
	            		BaseReportLookupParameter param = (BaseReportLookupParameter)iter.next();
	            		String code = param.getLookup().getCode();
	            		queryList.add(code);
	            	}
	            }
            	else {
            		queryList = emptyList;
            	}
            	
            	query.setParameterList("letterRejectReasons", queryList);
            }
            
            if (parameters.getAllLetterErrorTypes()) {
            	query.setString("is_error_all", "all");
            	query.setParameterList("letterErrorTypes", emptyList);
            }
            else {
            	query.setString("is_error_all", "notall");
            	List queryList = new ArrayList();
            	Set errorReasons = parameters.getLetterErrorTypes();
            	if (errorReasons.size() > 0) {
            		Iterator iter = errorReasons.iterator();
	            	while (iter.hasNext()) {
	            		BaseReportLookupParameter param = (BaseReportLookupParameter)iter.next();
	            		String code = param.getLookup().getCode();
	            		queryList.add(code);
	            	}
            	}
            	else {
            		queryList = emptyList;
            	}
            	query.setParameterList("letterErrorTypes", queryList);
            }
            
        }
        return query;
    }
    
}
