/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.esr.common.report.data;


// Java classes

// Library classes

// Framework classes
import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.report.data.QueryCriteria;

// ESR classes

/**
 * 
 *
 * Project: Framework</br>
 * Created on: 4:10:59 PM </br>
 *
 * @author DNS   LEV
 */
public class WeeklyReportNameResolver extends StandardReportNameResolver {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -8501385417540975648L;

	/**
	 * A default constructor
	 */
	public WeeklyReportNameResolver() {
		super();
	}

	/**
	 * @see gov.va.med.fw.report.ReportNameResolver#getReportName(gov.va.med.fw.report.ReportConfiguration)
	 */
	public String getReportName( ReportConfiguration config ) {
      QueryCriteria criteria = config.getQueryCriteria();
      StandardReportCriteria reportCriteria = criteria instanceof StandardReportCriteria ? (StandardReportCriteria)criteria : null;
      return reportCriteria != null ? reportCriteria.getSubReportName() : super.getReportName( config );
	}
}