/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.esr.common.report.data;

// Java classes

// Library classes

//ESR classes
import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.report.data.QueryCriteria;
import gov.va.med.fw.util.StringUtils;
import gov.va.med.esr.common.model.report.ReportSetup;
import gov.va.med.esr.common.model.report.ReportParameterSet;
import gov.va.med.esr.common.model.lookup.ReportFacilityDisplayBy;

/**
 * @author Kevin Edgecomb
 */
public class VOA1FacilityDisplayByReportNameResolver extends StandardReportNameResolver {

    private static final long serialVersionUID = -5836048768330615030L;

    /**
	 * @see gov.va.med.fw.report.FacilityDisplayByReportNameResolver#getReportName(gov.va.med.fw.report.ReportConfiguration)
	 */
	public String getReportName(ReportConfiguration config) {
		String name = super.getReportName( config );
        
		QueryCriteria criteria = config.getQueryCriteria();
		StandardReportCriteria reportCriteria = criteria instanceof StandardReportCriteria ? (StandardReportCriteria)criteria : null;
		if( reportCriteria != null ) {
			ReportSetup setup = reportCriteria.getReportSetup();
			ReportParameterSet params = setup != null ? setup.getParameterSet() : null;
            
            ReportFacilityDisplayBy facilityDisplayBy = params != null ? params.getFacilityDisplayBy() : null;
            if(facilityDisplayBy == null || StringUtils.isEmpty(facilityDisplayBy.getCode())) {
                //Do not append any suffix to the name
            } else if(StringUtils.equals(facilityDisplayBy.getCode(),ReportFacilityDisplayBy.CODE_VISN.getCode())) {
                name = name + "." + "visn";
            } else if(StringUtils.equals(facilityDisplayBy.getCode(),ReportFacilityDisplayBy.CODE_VISN_SITE.getCode())) {
                name = name + ".visn.site";
            } else {
                name = name + "." + "site";
            }
		}
		return name;
	}
}
