/**
 * 
 */
package gov.va.med.esr.common.report.data;

import java.util.Set;

import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.report.data.QueryCriteria;
import gov.va.med.fw.util.StringUtils;

import gov.va.med.esr.common.model.lookup.ReportFacilityDisplayBy;
import gov.va.med.esr.common.model.report.ReportParameterSet;
import gov.va.med.esr.common.model.report.ReportSetup;

/**
 * @author DNS   KATIKM
 *
 */
public class UserEnrolleeReportNameResolver extends StandardReportNameResolver {
	
    private static final long serialVersionUID = 5071772167257669078L;

    public String getReportName(ReportConfiguration config) {
		String name = super.getReportName( config );
        
		QueryCriteria criteria = config.getQueryCriteria();
		StandardReportCriteria reportCriteria = criteria instanceof StandardReportCriteria ? (StandardReportCriteria)criteria : null;
		if( reportCriteria != null ) {
			ReportSetup setup = reportCriteria.getReportSetup();
			ReportParameterSet params = setup != null ? setup.getParameterSet() : null;
            
            ReportFacilityDisplayBy facilityDisplayBy = params != null ? params.getFacilityDisplayBy() : null;
            if(facilityDisplayBy != null) {
            	if (ReportFacilityDisplayBy.CODE_VISN.getCode().equals(facilityDisplayBy.getCode())){
            		return name+"_VISN";
            	}
            	else if (ReportFacilityDisplayBy.CODE_VISN_SITE.getCode().equals(facilityDisplayBy.getCode())){
            		return name+"_SITE";
            	}
            	else if (ReportFacilityDisplayBy.CODE_SITE.getCode().equals(facilityDisplayBy.getCode())){
            		return name+"_SITE";
            	}            	
            }
		}
		return name; //return default name
	}
}
