/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.esr.common.report.data;

// Java classes

// Library classes

// Framework classes
import gov.va.med.esr.common.model.report.ReportParameterSet;
import gov.va.med.esr.common.model.report.ReportSetup;
import gov.va.med.fw.model.lookup.Lookup;
import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.report.SimpleReportNameResolver;
import gov.va.med.fw.report.data.QueryCriteria;
import gov.va.med.fw.util.StringUtils;

/**
 * 
 * 
 * Project: Common</br> Created on: 4:19:11 PM </br>
 * 
 * @author DNS   LEV
 */
public class StandardReportNameResolver extends SimpleReportNameResolver {

    /**
     * An instance of serialVersionUID
     */
    private static final long serialVersionUID = 2619282070914344190L;

    /**
     * A default constructor
     */
    public StandardReportNameResolver() {
        super();
    }
    
    /**
     * @see gov.va.med.fw.report.SimpleReportNameResolver#getReportName(gov.va.med.fw.report.ReportConfiguration)
     */
    public String getReportName(ReportConfiguration config) {
        QueryCriteria criteria = config.getQueryCriteria();
        StandardReportCriteria reportCriteria = criteria instanceof StandardReportCriteria ? (StandardReportCriteria) criteria
                : null;

        if (reportCriteria != null) {
            ReportSetup setup = reportCriteria.getReportSetup();
            ReportParameterSet parameterSet = setup != null ? setup.getParameterSet() : null;

            String reportFormat = getLookupDesc(parameterSet != null ? parameterSet.getReportFormat() : null);
            StringBuffer name = new StringBuffer();
            name.append(config.getReportName());
            appentToName(name, reportFormat);

            return name.toString();
        }
        return super.getReportName(config);
    }

    protected void appentToName(StringBuffer name, String desc) {
        if (desc != null) {
            name.append(".");
            name.append(StringUtils.deleteWhitespace(desc));
        }
    }

    protected String getLookupDesc(Lookup lookup) {
        return lookup != null ? lookup.getDescription() : null;
    }
}
