/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.esr.common.report.data;

// Java classes
import java.util.Map;

// Library classes
import org.apache.commons.lang.ClassUtils;

// Framework classes

// ESR classes
import gov.va.med.esr.common.model.report.ReportSetup;
import gov.va.med.fw.security.UserPrincipal;

/**
 * 
 *
 * Project: Common</br>
 * Created on: 2:12:09 PM </br>
 *
 * @author DNS   LEV
 */
public class StandardReportCriteria extends CommonCriteria {

	private static final String REPORT_SETUP = ClassUtils.getShortClassName( ReportSetup.class );
	private static final String REPORT_USER = ClassUtils.getShortClassName( UserPrincipal.class );
	
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -438223299183331564L;

	/**
	 * A default constructor
	 */
	public StandardReportCriteria() {
		super();
	}

	/**
	 * A default constructor
	 * @param criteria
	 */
	public StandardReportCriteria(Map criteria) {
		super(criteria);
	}

	public void setReportSetup( ReportSetup setup ) {
		this.addCriterion( REPORT_SETUP, setup );
	}
	
	public ReportSetup getReportSetup() {
		Object criterion = this.getCriteria().get( REPORT_SETUP );
		return criterion instanceof ReportSetup ? (ReportSetup)criterion : null;
	}

	public void setReportUser( UserPrincipal setup ) {
		this.addCriterion( REPORT_USER, setup );
	}
	
	public UserPrincipal getReportUser() {
		Object criterion = this.getCriteria().get( REPORT_USER );
		return criterion instanceof UserPrincipal ? (UserPrincipal)criterion : null;
	}

}