/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.esr.common.report.data;

import gov.va.med.fw.report.ReportConfiguration;

/**
 * SignedApplicationReportNameResolver 
 * @created Sep 27, 2006 2:23 PM
 * @author DNS   MANSOG
 */
public class SignedApplicationReportNameResolver extends StandardReportNameResolver {
    
    private static final long serialVersionUID = -7522703810467691761L;
    
    private String detailedName;

    /**
     * A default constructor
     */
    public SignedApplicationReportNameResolver() {
        super();
    }

    public String getReportName(ReportConfiguration config) {
        if (detailedName == null) {
            return super.getReportName(config);
        }
        return detailedName;
    }

    
    /**
     * @return Returns the detailedName.
     */
    public String getDetailedName() {
        return detailedName;
    }

    
    /**
     * @param detailedName The detailedName to set.
     */
    public void setDetailedName(String detailedName) {
        this.detailedName = detailedName;
    }
    
    
}