/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.report.data;

// Framework classes
import gov.va.med.esr.common.model.report.ReportParameterSet;
import gov.va.med.esr.common.model.report.ReportSetup;
import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.report.SimpleReportNameResolver;
import gov.va.med.fw.report.data.QueryCriteria;
import gov.va.med.fw.util.StringUtils;

/**
 * 
 * @author Muddaiah Ranga
 */
public class QM27ReportNameResolver extends SimpleReportNameResolver {

    /**
     * An instance of serialVersionUID
     */
    private static final long serialVersionUID = 2619282070914344190L;

    /**
     * A default constructor
     */
    public QM27ReportNameResolver() {
        super();
    }
    
    /**
     * @see gov.va.med.fw.report.SimpleReportNameResolver#getReportName(gov.va.med.fw.report.ReportConfiguration)
     */
    public String getReportName(ReportConfiguration config) {
        QueryCriteria criteria = config.getQueryCriteria();
        StandardReportCriteria reportCriteria = criteria instanceof StandardReportCriteria ? (StandardReportCriteria) criteria : null;

        if (reportCriteria != null) {
            ReportSetup setup = reportCriteria.getReportSetup();
            ReportParameterSet parameterSet = setup != null ? setup.getParameterSet() : null;

            String fileType = (parameterSet != null && parameterSet.getFileType() != null) ? StringUtils.lowerCase(parameterSet.getFileType().getDescription()) : null;
            StringBuffer name = new StringBuffer();
            name.append(config.getReportName());
            appentToName(name, fileType);

            return name.toString();
        }
        return super.getReportName(config);
    }

    protected void appentToName(StringBuffer name, String desc) {
        if (desc != null) {
            name.append(".");
            name.append(StringUtils.deleteWhitespace(desc));
        }
    }
}
