/**
 * 
 */
package gov.va.med.esr.common.report.data;

import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.report.data.QueryCriteria;

import gov.va.med.esr.common.model.report.ReportParameterSet;
import gov.va.med.esr.common.model.report.ReportSetup;

/**
 * @author DNS   KATIKM
 *
 */
public class QM11ReportNameResolver extends StandardReportNameResolver {
    
    private static final long serialVersionUID = 3337168564533114693L;

    public String getReportName(ReportConfiguration config) {
        String name = super.getReportName( config );
        
        QueryCriteria reportCriteria = config.getQueryCriteria();
        StandardReportCriteria criteria = (StandardReportCriteria)reportCriteria;
        ReportSetup setup = criteria.getReportSetup();
    
        ReportParameterSet parameters = setup != null ? setup.getParameterSet() : null;

        if (parameters != null && parameters.getRunReportByUser()) {
            return name + ".User";
        }
        return name; //return default name
    }
}
