/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.esr.common.report.data;

import gov.va.med.esr.common.model.report.ReportParameterSet;
import gov.va.med.esr.common.model.report.ReportSetup;
import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.report.data.QueryCriteria;

/**
 * PhRejectReportNameResolver 
 * Created
 * @author DNS   GUPTAS
 */
public class PhRejectReportNameResolver extends StandardReportNameResolver {

    private static final long serialVersionUID = -2865541915165764440L;

    /**
     * A default constructor
     */
    public PhRejectReportNameResolver() {
        super();
    }

    public String getReportName(ReportConfiguration config) {
        QueryCriteria criteria = config.getQueryCriteria();
        StandardReportCriteria reportCriteria = criteria instanceof StandardReportCriteria ? (StandardReportCriteria) criteria
                : null;

        if (reportCriteria != null) {
        	StringBuffer name = new StringBuffer();
        	name.append(config.getReportName());
        	
            ReportSetup setup = reportCriteria.getReportSetup();
            ReportParameterSet parameterSet = setup != null ? setup.getParameterSet() : null;

            String reportFormat = (parameterSet != null) ? getLookupDesc(parameterSet.getReportFormat()) : "";
            boolean includeUsers = (parameterSet != null) ? parameterSet.getIncludeUsers() : false;
            
            if (includeUsers == true) {
            	appentToName(name, "IU");
            }
            appentToName(name, reportFormat);

            return name.toString();
        }
        return super.getReportName(config);
    }
}