package gov.va.med.esr.common.report.data;

import gov.va.med.esr.common.model.lookup.ReportFormat;
import gov.va.med.esr.common.model.report.ReportParameterSet;
import gov.va.med.esr.common.model.report.ReportSetup;
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.report.data.QueryCriteria;

/**
 * PersonMergeReportNameResolver
 * Created
 * @author DNS   GUPTAS
 */
public class PersonMergeReportNameResolver extends StandardReportNameResolver {

    private static final long serialVersionUID = 9197542191606766942L;

    /**
     * A default constructor
     */
    public PersonMergeReportNameResolver() {
        super();
    }

    public String getReportName(ReportConfiguration config) {
        QueryCriteria criteria = config.getQueryCriteria();
        StandardReportCriteria reportCriteria = criteria instanceof StandardReportCriteria ? (StandardReportCriteria) criteria
                : null;

		//<entry key="EED12.Summary" value="EED12.Summary.dataDAO"/>
		//<entry key="EED12.Summary.ByUser" value="EED12.Summary.ByUser.dataDAO"/>
		//<entry key="EED12.Detailed" value="EED12.Detailed.dataDAO"/>

        if (reportCriteria != null) {
        	StringBuffer name = new StringBuffer();
        	name.append(config.getReportName());

            ReportSetup setup = reportCriteria.getReportSetup();
            ReportParameterSet parameterSet = setup != null ? setup.getParameterSet() : null;

            String reportFormat = (parameterSet != null) ? getLookupDesc(parameterSet.getReportFormat()) : "";
            appentToName(name, reportFormat);
            
            AbstractCode code = (parameterSet != null) ? parameterSet.getReportFormat().getCodeObject() : null;

            return name.toString();
        }
        return super.getReportName(config);
    }
}
