/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.report.data;

import gov.va.med.fw.util.StringUtils;

/**
 * @author Muddaiah Ranga
 */
public class ParameterConfig {
    
    public final static String STRING = "string";
    public final static String DATE = "date";
    
    private String label;
    private boolean required;
    private String type;
    private int dateRangeInDays;
    private String dependentField;
    private boolean preciseDate;
    private boolean futureDateAllowed;
    
    private String  parameterName;
    private boolean displayParameter = true;
    private String defaultValue;
    
    public String getLabel() {
        return label;
    }
    public void setLabel(String label) {
        this.label = label;
    }
    
    public boolean isRequired() {
        return required;
    }
    public void setRequired(boolean required) {
        this.required = required;
    }
    
    public String getType() {
        return type;
    }
    public void setType(String type) {
        this.type = type;
    }
    
    public boolean isDate() {
        return StringUtils.equalsIgnoreCase(this.getType(),DATE) ? true : false;
    }
    
    public boolean isPreciseDate() {
        return preciseDate;
    }
    public void setPreciseDate(boolean preciseDate) {
        this.preciseDate = preciseDate;
    }
    
    public int getDateRangeInDays() {
        return dateRangeInDays;
    }
    public void setDateRangeInDays(int dateRangeInDays) {
        this.dateRangeInDays = dateRangeInDays;
    }
    
    public String getDependentField() {
        return dependentField;
    }
    public void setDependentField(String dependentField) {
        this.dependentField = dependentField;
    }
    
    public boolean isFutureDateAllowed() {
        return futureDateAllowed;
    }
    public void setFutureDateAllowed(boolean futureDateAllowed) {
        this.futureDateAllowed = futureDateAllowed;
    }
    public String getParameterName() {
        return parameterName;
    }
    public void setParameterName(String parameterName) {
        this.parameterName = parameterName;
    }
    public boolean isDisplayParameter() {
        return displayParameter;
    }
    public void setDisplayParameter(boolean displayParameter) {
        this.displayParameter = displayParameter;
    }
    public String getDefaultValue() {
        return this.defaultValue;
    }
    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }    
}
