/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.esr.common.report.data;

// Java classes

// Library classes

// Framework classes
import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.report.SimpleReportNameResolver;

// ESR classes

/**
 * 
 *
 * Project: Common</br>
 * Created on: 4:19:11 PM </br>
 *
 * @author DNS   LEV
 */
public class OPPReportNameResolver extends SimpleReportNameResolver {
	
	private static final String MAIN_OPP_EXTRACT_FILE = "OPP5";
	private static final String MAIN_FILE_TPL = "MainFileTemplate";
	private static final String COMMON_FILE_TPL = "CommonFileTemplate";

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 2619282070914344190L;

	/**
	 * A default constructor
	 */
	public OPPReportNameResolver() {
		super();
	}

	/**
	 * @see gov.va.med.fw.report.SimpleReportNameResolver#getReportName(gov.va.med.fw.report.ReportConfiguration)
	 */
	public String getReportName(ReportConfiguration config) {
		String name = super.getReportName( config );
		return MAIN_OPP_EXTRACT_FILE.equals( name ) ? MAIN_FILE_TPL : COMMON_FILE_TPL;
	}
}