/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.esr.common.report.data;

// Java classes

// Library classes
import org.springframework.context.MessageSource;

// Framework classes

// ESR classes

/**
 * Encapsulates data needed to generate report for an OPP main extract
 * file.  
 *
 * Project: Common</br>
 * Created on: 1:25:19 PM </br>
 *
 * @author DNS   LEV
 */
public class MainFileCriteria extends CommonExtractFileCriteria {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -6472235570095855809L;
	
	private static final String TOTAL_ENROLLEES = "total_enrollees";
	private static final String DECEASED_BENEFICIARIES = "deceased_beneficiaries";
	private static final String CANCELLED_DECLINED_ENROLLEES = "cancelled_declined_enrollees";
	private static final String NOT_ELIGIBLE_BENEFICIARIES = "not_eligible_beneficiaries";
	private static final String REQUIRED_MEANS_TESTS = "required_means_tests";
	private static final String AUTO_ENROLLED_RECORDS = "auto_enrolled_records";
	private static final String UNOFFICIAL_ENROLLEES = "unofficial_enrollees";
	private static final String OFFICIAL_ENROLLEES = "official_enrollees";
	private static final String INSURANCES = "insurances";
	
	
	/**
	 * A default constructor
	 * @param type
	 * @param bundle
	 */
	public MainFileCriteria() {
		super( CommonExtractFileCriteria.MAIN_FILE );
	}
	/**
	 * A default constructor
	 * @param type
	 */
	public MainFileCriteria( MessageSource bundle ) {
		super(  CommonExtractFileCriteria.MAIN_FILE, bundle );
	}
	public void setTotalEnrollees( Integer total ) {
		this.addCriterion( TOTAL_ENROLLEES, total );
	}
	public Integer getTotalEnrollees() {
		Object criterion = this.getCriteria().get( TOTAL_ENROLLEES );
		return criterion instanceof Integer ? (Integer)criterion : null;
	}
	public void setDeceasedBeneficiaries( Integer total ) {
		this.addCriterion( DECEASED_BENEFICIARIES, total );
	}
	public Integer getDeceasedBeneficiaries() {
		Object criterion = this.getCriteria().get( DECEASED_BENEFICIARIES );
		return criterion instanceof Integer ? (Integer)criterion : null;
	}
	public void setCancelledDeclinedEnrollees( Integer total ) {
		this.addCriterion( CANCELLED_DECLINED_ENROLLEES, total );
	}
	public Integer getCancelledDeclinedEnrollees() {
		Object criterion = this.getCriteria().get( CANCELLED_DECLINED_ENROLLEES );
		return criterion instanceof Integer ? (Integer)criterion : null;
	}
	public void setIneligibleBeneficiaries( Integer total ) {
		this.addCriterion( NOT_ELIGIBLE_BENEFICIARIES, total );
	}
	public Integer getIneligibleBeneficiaries() {
		Object criterion = this.getCriteria().get( NOT_ELIGIBLE_BENEFICIARIES );
		return criterion instanceof Integer ? (Integer)criterion : null;
	}
	public void setRequiredMeansTests( Integer total ) {
		this.addCriterion( REQUIRED_MEANS_TESTS, total );
	}
	public Integer getRequiredMeansTests() {
		Object criterion = this.getCriteria().get( REQUIRED_MEANS_TESTS );
		return criterion instanceof Integer ? (Integer)criterion : null;
	}
	public void setAutoEnrolledRecords( Integer total ) {
		this.addCriterion( AUTO_ENROLLED_RECORDS, total );
	}
	public Integer getAutoEnrolledRecords() {
		Object criterion = this.getCriteria().get( AUTO_ENROLLED_RECORDS );
		return criterion instanceof Integer ? (Integer)criterion : null;
	}
	public void setUnOfficialEnrollees( Integer total ) {
		this.addCriterion( UNOFFICIAL_ENROLLEES, total );
	}
	public Integer getUnOfficialEnrollees() {
		Object criterion = this.getCriteria().get( UNOFFICIAL_ENROLLEES );
		return criterion instanceof Integer ? (Integer)criterion : null;
	}
	public void setOfficialEnrollees( Integer total ) {
		this.addCriterion( OFFICIAL_ENROLLEES, total );
	}
	public Integer getOfficialEnrollees() {
		Object criterion = this.getCriteria().get( OFFICIAL_ENROLLEES );
		return criterion instanceof Integer ? (Integer)criterion : null;
	}
	public void setInsurances( Integer total ) {
		this.addCriterion( INSURANCES, total );
	}
	public Integer getInsurances() {
		Object criterion = this.getCriteria().get( INSURANCES );
		return criterion instanceof Integer ? (Integer)criterion : null;
	}
}