/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.esr.common.report.data;

import gov.va.med.esr.common.model.report.ReportParameterSet;
import gov.va.med.esr.common.model.report.ReportSetup;
import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.report.data.QueryCriteria;

/**
 * InProcessReportNameResolver 
 * Created Sep 18, 2006 5:56:45 PM
 * @author DNS   MANSOG
 */
public class InProcessReportNameResolver extends StandardReportNameResolver {

    private static final long serialVersionUID = 8165877753510681754L;

    /**
     * A default constructor
     */
    public InProcessReportNameResolver() {
        super();
    }

    public String getReportName(ReportConfiguration config) {
        String reportName = super.getReportName(config);

        QueryCriteria criteria = config.getQueryCriteria();
        StandardReportCriteria reportCriteria = criteria instanceof StandardReportCriteria ? (StandardReportCriteria) criteria
                : null;

        if (reportCriteria != null) {
            ReportSetup setup = reportCriteria.getReportSetup();
            ReportParameterSet parameterSet = setup != null ? setup.getParameterSet() : null;

            String detailBy = getLookupDesc(parameterSet != null ? parameterSet.getDetailBy() : null);
            String detailFor = getLookupDesc(parameterSet != null ? parameterSet.getDetailFor() : null);

            StringBuffer name = new StringBuffer();
            name.append(reportName);
            appentToName(name, detailBy);
            appentToName(name, detailFor);

            return name.toString();
        }
        return reportName;
    }
}