/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.esr.common.report.data;

import gov.va.med.esr.common.model.lookup.ReportFormat;
import gov.va.med.esr.common.model.report.ReportParameterSet;
import gov.va.med.esr.common.model.report.ReportSetup;
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.report.data.QueryCriteria;

/**
 * EnrollmentOverrideReportNameResolver
 * Created
 * @author DNS   GUPTAS
 */
public class EnrollmentOverrideReportNameResolver extends StandardReportNameResolver {

    private static final long serialVersionUID = 239623634475481410L;

    /**
     * A default constructor
     */
    public EnrollmentOverrideReportNameResolver() {
        super();
    }

    public String getReportName(ReportConfiguration config) {
        QueryCriteria criteria = config.getQueryCriteria();
        StandardReportCriteria reportCriteria = criteria instanceof StandardReportCriteria ? (StandardReportCriteria) criteria
                : null;

				//<entry key="EED9.Summary" value="EED9.Summary.dataDAO"/>
				//<entry key="EED9.Summary.ByReason" value="EED9.Summary.ByReason.dataDAO"/>
				//<entry key="EED9.Detailed" value="EED9.Detailed.dataDAO"/>
				//<entry key="EED9.Detailed.ByLAS" value="EED9.Detailed.ByLAS.dataDAO"/>

        if (reportCriteria != null) {
        	StringBuffer name = new StringBuffer();
        	name.append(config.getReportName());

            ReportSetup setup = reportCriteria.getReportSetup();
            ReportParameterSet parameterSet = setup != null ? setup.getParameterSet() : null;

            String reportFormat = (parameterSet != null) ? getLookupDesc(parameterSet.getReportFormat()) : "";
            appentToName(name, reportFormat);
            
            AbstractCode code = (parameterSet != null) ? parameterSet.getReportFormat().getCodeObject() : null;
            if (ReportFormat.DETAIL.equals(code)) {
	            String detailBy = getLookupDesc(parameterSet != null ? parameterSet.getDetailBy() : null);
	            // code to be removed later
	            
	            if (detailBy != null) {
	            	appentToName(name, detailBy);
	            }
            }
            else {
            	if (parameterSet != null && parameterSet.getEnrollmentOverrideReasons().isEmpty() == false) {
            		appentToName(name, "ByReason");
            	}
            }

            return name.toString();
        }
        return super.getReportName(config);
    }
}