/**
 * 
 */
package gov.va.med.esr.common.report.data;

import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.report.data.QueryCriteria;


import gov.va.med.esr.common.model.lookup.ReportFacilityDisplayBy;
import gov.va.med.esr.common.model.lookup.ReportFormat;
import gov.va.med.esr.common.model.report.ReportParameterSet;
import gov.va.med.esr.common.model.report.ReportSetup;

/**
 * @author DNS   KULLAV
 *
 */
public class EnrolleeEnrollmentStatusReportNameResolver extends StandardReportNameResolver {
	
	
	private static final long serialVersionUID = -6052702647771573500L;

	public String getReportName(ReportConfiguration config) {
		String name = super.getReportName( config );
        
		QueryCriteria criteria = config.getQueryCriteria();
		StandardReportCriteria reportCriteria = criteria instanceof StandardReportCriteria ? (StandardReportCriteria)criteria : null;
		if( reportCriteria != null ) {
			ReportSetup setup = reportCriteria.getReportSetup();
			ReportParameterSet params = setup != null ? setup.getParameterSet() : null;
            ReportFormat format=params != null ? params.getReportFormat() : null;
            ReportFacilityDisplayBy facilityDisplayBy = params != null ? params.getFacilityDisplayBy() : null;
            if(facilityDisplayBy != null && format!=null && format.getCode() != null && format.getCode().equals(ReportFormat.SUMMARY.getCode()) ) {
            	if (ReportFacilityDisplayBy.CODE_VISN.getCode().equals(facilityDisplayBy.getCode())){
            		return name+"_VISN";
            	}
            	else if (ReportFacilityDisplayBy.CODE_VISN_SITE.getCode().equals(facilityDisplayBy.getCode())){
            		return name+"_VISN_SITE";
            	}
            	else if (ReportFacilityDisplayBy.CODE_SITE.getCode().equals(facilityDisplayBy.getCode())){
            		return name+"_SITE";
            	}
            	else if (ReportFacilityDisplayBy.CODE_VAMC.getCode().equals(facilityDisplayBy.getCode())){
            		return name+"_VAMC";
            	}
            	else if (ReportFacilityDisplayBy.CODE_VAMC_SITE.getCode().equals(facilityDisplayBy.getCode())){
            		return name+"_VAMC_SITE";
            	}
            	else if (ReportFacilityDisplayBy.CODE_VISN_VAMC.getCode().equals(facilityDisplayBy.getCode())){
            		return name+"_VISN_VAMC";
            	}
            	else if (ReportFacilityDisplayBy.CODE_VISN_VAMC_SITE.getCode().equals(facilityDisplayBy.getCode())){
            		return name+"_VISN_VAMC_SITE";
            	}
            }
		}
		return name; //return default name
	}
}
