/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.esr.common.report.data;

// Java classes
import gov.va.med.fw.report.data.QueryCriteria;

import java.util.Date;
import java.util.Map;

// ESR classes

/**
 * Project: Common
 * @created: 2:12:09 PM </br>
 * @author DNS   LEV
 */
public class CommonCriteria extends QueryCriteria {

    /**
     * An instance of serialVersionUID
     */
    private static final long  serialVersionUID     = 2824659588794669178L;

    public static final String REGISTRY_TYPE        = "registryType";
    public static final String BAD_ADDRESS_REASON   = "reason";
    public static final String START_DATE           = "startDate";
    public static final String END_DATE             = "endDate";
    public static final String RUN_DATE             = "runDate";
    public static final String REPORT_TYPE          = "Type";
    public static final String REPORT_TITLE         = "Title";
    public static final String REPORT_PERIOD        = "Period";
    public static final String REPORT_TYPE_CODE     = "Type_Code";
    public static final String EMAIL                = "email";
    public static final String COM_LETTER_TYPE      = "comLetterType";
    public static final String MESSAGE_TYPE         = "messageType";
    public static final String MESSAGE_TYPES        = "messageTypes";
    public static final String ACK_TYPES         	= "ackTypes";
    public static final String MESSAGE_ERROR        = "messageError";
    public static final String INCOME_YEAR          = "incomeYear";
    public static final String END_INCOME_YEAR      = "endIncomeYear";
    public static final String AS_OF_DATE           = "asOfDate";
    public static final String PH_UNCONFIRMED_DAYS  = "phUnconfirmedDays";
    public static final String VISNS                = "visns";
    public static final String VAMCS                = "vamcs";
    public static final String FACILITIES           = "facilities";
    public static final String IS_ALL               = "is_all";
    public static final String IS_NULL              = "is_null";
    public static final String IS_NOT_NULL          = "is_not_null";
    public static final String QUERY_TYPE           = "type";
    public static final String DAYS_BETWEEN_UPDATES = "daysBetweenUpdates";
    public static final String EXCEED_X_DAYS        = "exceedXDays";
    public static final String ADDRESS_UPDATE_DAYS  = "addressUpdateDays";
    public static final String ENROLLMENT_STATUSES  = "enrollmentStatuses";
    public static final String ALL_FACILITIES       = "all_facilities";
    public static final String ALL_GROUPS           = "all_groups";
    public static final String ALL_SUB_GROUPS       = "all_subGroups";
    public static final String ALL_STATUSES         = "all_statuses";
    public static final String GROUP_PRIORITIES     = "groupPriorities";
    public static final String SUB_GROUP_PRIORITIES = "subGroupPriorities";
    public static final String DIRECTION            = "direction";
    public static final String BATCH_NUMBER         = "batchNumber";
    public static final String EXCEPTION_TYPE       = "exceptionType";
    public static final String FILE_TYPE			= "fileType";
    public static final String IS_NO_VISN            = "noVISN";
    public static final String AS_OF_DATE_FLAG      = "asOfDateFlag";
    public static final String FACILITY_TYPE        = "facilityType";
    public static final String FIRST_FACILITY_LIST  = "firstFacilityList";
    public static final String SECOND_FACILITY_LIST = "secondFacilityList";
    public static final String IS_ALL_ELIG          = "is_all_elig";
    public static final String ELIGIBILITY_FACTORS  = "eligibilityFactors";
    public static final String VOA_FORM_TYPES  		= "voaFormTypes";
    public static final String ALL_VOA_FORM_TYPES   = "allFormTypes";

    /**
     * A default constructor
     */
    public CommonCriteria() {
        super();
    }

    /**
     * A default constructor
     * @param criteria
     */
    public CommonCriteria(Map criteria) {
        super(criteria);
    }

    public void setFileType(String fileType) {
    	this.addCriterion(FILE_TYPE, fileType);
    }
    
    public void setStartDate(Date date) {
        this.addCriterion(START_DATE, date);
    }

    public void setReportPeriodType(String type) {
        this.addCriterion(REPORT_TYPE, type);
    }

    public void setReportPeriodTypeCode(String code) {
        this.addCriterion(REPORT_TYPE_CODE, code);
    }

    public void setReportPeriod(String period) {
        this.addCriterion(REPORT_PERIOD, period);
    }

    public void setEndDate(Date date) {
        this.addCriterion(END_DATE, date);
    }

    public void setRunDate(Date date) {
        this.addCriterion(RUN_DATE, date);
    }
    
    public void setExceedXDays(String days) {
    	this.addCriterion(EXCEED_X_DAYS, days);
    }

    public Date getStartDate() {
        Object criterion = this.getCriteria().get(START_DATE);
        return criterion instanceof Date ? (Date) criterion : null;
    }

    public Date getEndDate() {
        Object criterion = this.getCriteria().get(END_DATE);
        return criterion instanceof Date ? (Date) criterion : null;
    }

    public Date getRunDate() {
        Object criterion = this.getCriteria().get(RUN_DATE);
        return criterion instanceof Date ? (Date) criterion : null;
    }

    public String getReportPeriodType() {
        Object criterion = this.getCriteria().get(REPORT_TYPE);
        return criterion instanceof String ? (String) criterion : null;
    }

    public String getReportPeriodTypeCode() {
        Object criterion = this.getCriteria().get(REPORT_TYPE_CODE);
        return criterion instanceof String ? (String) criterion : null;
    }

    public String getReportPeriod() {
        Object criterion = this.getCriteria().get(REPORT_PERIOD);
        return criterion instanceof String ? (String) criterion : null;
    }

    /**
     * @return
     */
    public String[] getBadAddressReasons() {

        Object criterion = this.getCriteria().get(BAD_ADDRESS_REASON);
        return criterion instanceof String[] ? (String[]) criterion : null;
    }

    /**
     * @param reason
     */
    public void setBadAddressReason(String[] reasons) {
        this.addCriterion(BAD_ADDRESS_REASON, reasons);
    }

    /**
     * @return
     */
    public Integer getIncomeYear() {

        Object criterion = this.getCriteria().get(INCOME_YEAR);
        return criterion instanceof Integer ? (Integer) criterion : null;
    }

    /**
     * @param reason
     */
    public void setIncomeYear(Integer incomeYear) {
        this.addCriterion(INCOME_YEAR, incomeYear);
    }
    
    public void setEndIncomeYear(Integer endIncomeYear) {
    	this.addCriterion(this.END_INCOME_YEAR, endIncomeYear);
    }
}