/**
 * 
 */
package gov.va.med.esr.common.report.data;

import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.report.data.QueryCriteria;

import gov.va.med.esr.common.model.lookup.ReportFacilityDisplayBy;
import gov.va.med.esr.common.model.report.ReportParameterSet;
import gov.va.med.esr.common.model.report.ReportSetup;

/**
 * @author DNS   KATIKM
 *
 */
public class CancelDeclineReportNameResolver extends StandardReportNameResolver {
	
    private static final long serialVersionUID = 7465175570123225882L;

    public String getReportName(ReportConfiguration config) {
		
		//Name is appended with summary or detailed
		String name = super.getReportName( config );
        
		QueryCriteria criteria = config.getQueryCriteria();
		StandardReportCriteria reportCriteria = criteria instanceof StandardReportCriteria ? (StandardReportCriteria)criteria : null;
		if( reportCriteria != null ) {
			ReportSetup setup = reportCriteria.getReportSetup();
			ReportParameterSet params = setup != null ? setup.getParameterSet() : null;
            
            ReportFacilityDisplayBy facilityDisplayBy = params != null ? params.getFacilityDisplayBy() : null;
            if(facilityDisplayBy != null) {
            	if (ReportFacilityDisplayBy.CODE_VISN.getCode().equals(facilityDisplayBy.getCode())){
            		return name+".visn";
            	}
            	else if (ReportFacilityDisplayBy.CODE_VISN_SITE.getCode().equals(facilityDisplayBy.getCode())){
            		return name+".visn.site";
            	}
            	else if (ReportFacilityDisplayBy.CODE_SITE.getCode().equals(facilityDisplayBy.getCode())){
            		return name+".site";
            	}            	
            }
		}
		return name; //return default name
	}
}
