/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.persistent.workflow;
import gov.va.med.esr.common.model.cases.WorkflowCase;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.service.WorkflowSearchCriteria;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.DAOOperations;
import gov.va.med.fw.persistent.MaxRecordsExceededException;
import gov.va.med.fw.service.pagination.SearchQueryInfo;

import java.util.List;

/**
 * A DAO to provide specific business information about a  WorkflowCase 
 * Updated Madhu Katikala
 */

public interface WorkflowDAO extends DAOOperations
{
    
    /**
     * Generic Non-Paginated search query
     * @param wkfsearchCriteria
     * @return
     * @throws DAOException
     */
     public List getWorkItems(WorkflowSearchCriteria wkfsearchCriteria) throws DAOException;

     /**
      * Generic Paginated search query
      * @param searchCriteria
      * @return
      * @throws DAOException
      */
     public List find(SearchQueryInfo searchCriteria) throws DAOException, MaxRecordsExceededException;

     /**
      * Retrives number of open cases for a Veteran
      * @param personEntityKey
      * @return
      * @throws DAOException
      */
     public int getOpenCasesCount(PersonEntityKey personEntityKey) throws DAOException;
     
	/**
	 * Retrieves the most recently added workflow case for a person. Null if none are found 
	 * @param personEntityKey
	 * @return
	 * @throws DAOException
	 */
	public WorkflowCase getMostRecentlyCreatedWorkflowItem(PersonEntityKey personEntityKey) throws DAOException;

     /** CCR_9809
      * Gets count of work items
      * @param workflowSearchCriteria
      * @return
      * @throws DAOException
      */
     public int getWorkItemsCount(WorkflowSearchCriteria workflowSearchCriteria) throws DAOException;      
     
     /**
      * Gets all open work items
      * @param WorkflowCase
      * @return
      * @throws DAOException
      */
     public List getMatchingOpenCasesForAWorkItem(WorkflowCase workFlowCase) throws DAOException;
}