/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.persistent.system.hibernate;

import java.util.Iterator;
import java.util.List;
import java.util.Set;

import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.hibernate.GenericDAOImpl;

import gov.va.med.esr.common.model.system.SystemParameter;
import gov.va.med.esr.common.persistent.system.SystemParameterDAO;

public class SystemParameterDAOImpl extends GenericDAOImpl implements
        SystemParameterDAO {

    private static final long serialVersionUID = 3480611140898967024L;

    public SystemParameterDAOImpl() {
        super();
    }
    
    /**
     * Find All System parameters
     */
    public List findAll() throws DAOException
    {
        return findByNamedQuery("systemParameterQuery_FindAll",null);
    }
    
    /**
     * Find the named system parameter
     */
    public SystemParameter getByName(String parameterName) throws DAOException
    {        
        List parameters = findByNamedQueryAndNamedParam("systemParameter_findByName", "name", parameterName);
        if (parameters != null && parameters.size() > 0) {
            if (parameters.size() == 1) 
                return (SystemParameter)parameters.get(0);
            else if (parameters.size() > 1) {
                throw new DAOException("More than one System Parameter found for " + parameterName);
            }
        }
        //System Parameter not found
        return null;
    }
    
    /**
     * Update the set of system parameters
     */
    public Set update(Set parameters) throws DAOException
    {
        for (Iterator i=parameters.iterator(); i.hasNext();) {
            update(i.next());
        }
        return parameters;
    }
}
