package gov.va.med.esr.common.persistent.person.hibernate;

import java.util.List;
import java.math.BigDecimal;

import org.hibernate.HibernateException;
import gov.va.med.esr.common.model.person.SSNVerificationDetail;
import gov.va.med.esr.common.persistent.person.SSNVerificationDetailDAO;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.hibernate.GenericDAOImpl;
/**
 * DAO implementation to retrieve SSNVerificationDetail
 *   
 * @author Rajiv Patnaik
 * Created on Mar 20, 2006
 * @version 1.0
 * 
 * Copyright  2006 VHA. All rights reserved
 */
public class SSNVerificationDetailDAOImpl extends GenericDAOImpl implements SSNVerificationDetailDAO
{
    private static final long serialVersionUID = -7754423167627386329L;
    
    private static final String GET_BY_HEC_INTERNAL_ID= "query_GetByHecInternalId";
    private static final String PARAM_HEC_INTERNAL_ID= "HECInternalId";
    
    private static final String GET_LIST_TO_PROCESS= "query_GetListToProcess"; //CCR11666
    private static final String GET_BY_PERSON_ID= "query_GetByPersonId"; //CCR11666
    private static final String PARAM_Person_ID= "personId"; //CCR11666
    
    /* (non-Javadoc)
     * @see gov.va.med.esr.common.persistent.person.SSNVerificationDetailDAO#getSSNVerificationDetailByHECInternalId(java.lang.String)
     */
    public SSNVerificationDetail getSSNVerificationDetailByHECInternalId(
            String HECInternalId) throws DAOException
    {
        try
        {
			List results = findByNamedQueryAndNamedParam(GET_BY_HEC_INTERNAL_ID,
					PARAM_HEC_INTERNAL_ID, HECInternalId);

			SSNVerificationDetail ssnVerificationDetail = ((results == null) || results.isEmpty()) ? null
					: ((SSNVerificationDetail)results.get(0));

			return ssnVerificationDetail;
            
        }
        catch(HibernateException e)
        {
            throw new DAOException("Failed to get SSNVerificationDetail by HEC Internal Id.", e);
        }
     }
    
    public List getSSNVerificationListToProcess()  throws DAOException //CCR11666
    {
        try
        {
			List results = this.find(GET_LIST_TO_PROCESS);
			return results;
            
        }
        catch(HibernateException e)
        {
            throw new DAOException("Failed to get List of SSNVerificationDetail to process.", e);
        }
    }
    
//  CCR 11666 
    public SSNVerificationDetail getSSNVerificationDetailByPersonId(BigDecimal personId) throws DAOException
    {
        try
        {
			List results = findByNamedQueryAndNamedParam(GET_BY_PERSON_ID,
					PARAM_Person_ID, personId);

			SSNVerificationDetail ssnVerificationDetail = ((results == null) || results.isEmpty()) ? null
					: ((SSNVerificationDetail)results.get(0));

			return ssnVerificationDetail;
            
        }
        catch(HibernateException e)
        {
            throw new DAOException("Failed to get SSNVerificationDetail by Person Id.", e);
        }
     }
}
