/********************************************************************
 * Copyright  2004-2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.persistent.person.hibernate;

// Java Classes
import java.util.List;

import org.hibernate.HibernateException;

import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.PreferredFacilityPerson;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.common.model.person.id.VPIDEntityKey;
import gov.va.med.esr.common.persistent.person.PreferredFacilityDAO;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.hibernate.GenericDAOImpl;

/**
 * This class is a DAO implementation that searches and retrieves objects used by Preferred Facility processes.
 */
public class PreferredFacilityDAOImpl extends GenericDAOImpl implements PreferredFacilityDAO
{
	/**
	 * 
	 */
	private static final long serialVersionUID = -3490525038789642102L;
	
	private boolean isDataClean = true;
	private static final String GET_BY_VPID = "PF_personQuery_GetByVPID";
	private static final String PARAM_FOR_GET_BY_VPID = "VPIDValue";
	private static final String GET_CHILD_VAFACILITY = "childVaFacilityQuery_GetByIds";
	
	private static final String GET_ENROLLMENT_COUNT = "PF_GetEnrollmentCount";
	private static final String PARAM_PERSON_ID = "personId";
	
	/*
	 * Method to retrieve a lightweight person by VPID for use by preferred facility batch process
	 */
	public PreferredFacilityPerson getPreferredFacilityPersonByVPID(VPIDEntityKey key) throws DAOException {
    	if(key == null)
    		return null;

        List persons = findByNamedQueryAndNamedParam(GET_BY_VPID, PARAM_FOR_GET_BY_VPID, key.getVPID());
        verifyDataIntegrity(key, persons);
        return (PreferredFacilityPerson) (persons.size() >= 1 ? persons.get(0) : null);
	}



   private void verifyDataIntegrity(VPIDEntityKey vpid, List persons) throws DAOException {
        if (persons.size() > 1) {
        	if(isDataClean)
        		throw new DAOException("Found more than one Person for VPID: " + vpid.getVPID());
	
	if(logger.isErrorEnabled()) {
		Object firstObject = persons.get(0);    			
		Object personId = firstObject;
		if(firstObject instanceof Person)
			personId = ((Person) firstObject).getPersonEntityKey().getKeyValueAsString();
		else if(firstObject instanceof Object[])
			personId = ((Object[]) firstObject)[0];
	
		logger.error("The data is not clean since there is more than one (actually " + persons.size() + ") Person for VPID: " + vpid.getVPID() +
				" - arbitrarily choosing first one, it has personId=" + personId);
			}
	    }
	}
   public List getChildVaFacility(List parentSiteIds) throws DAOException
   {
       try
       {
       	List results = findByNamedQueryAndNamedParam(GET_CHILD_VAFACILITY,
       			"siteId", parentSiteIds);
       	return results;
        }
       catch(HibernateException e)
       {
    	   throw new DAOException("Failed to get  Child VAFacility by Id.", e);
       }
   }
   
   public int getEnrollmentRecordCount(PersonEntityKey personId) throws DAOException
   {   
	   List count = findByNamedQueryAndNamedParam(GET_ENROLLMENT_COUNT, PARAM_PERSON_ID, personId.getKeyValue());
       return ((Integer)count.get(0)).intValue();

   }
}