/*
 * Created on Feb 28, 2006
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package gov.va.med.esr.common.persistent.person.hibernate;

import java.math.BigDecimal;
import java.util.List;
import gov.va.med.esr.common.model.person.PersonUnmergeInfo;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKey;
import gov.va.med.esr.common.persistent.person.PersonUnmergeDAO;
import gov.va.med.fw.persistent.DAOException;
import org.apache.commons.lang.Validate;
import gov.va.med.fw.persistent.hibernate.GenericDAOImpl;
import org.springframework.dao.DataAccessException;

/**
 * @author DNS   CHENJ2
 *
 */
public class PersonUnmergeDAOImpl extends GenericDAOImpl implements
		PersonUnmergeDAO {
	
    private static final String FIND_PERSON_UNMERGE_BY_PERSON_IDS = "personUnmerge_FindByPersonIds";
    private static final String PARAM_PERSON_ID1        = "personId1";
    private static final String PARAM_PERSON_ID2        = "personId2";

    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 5105022579595690993L;

	public PersonUnmergeInfo findByPersonIds(PersonIdEntityKey personId1, PersonIdEntityKey personId2) throws DAOException {
		// TODO: the query needs to go both directions (primary=psn1 deprecated=psn2; then primary=psn2 deprecated=psn1)
		Validate.notNull(personId1, "NULL personId1 not allowed.");
		Validate.notNull(personId2, "NULL personId2 not allowed.");
		
		String[] paramNames = new String[] {PARAM_PERSON_ID1, PARAM_PERSON_ID2};
		Object[] values = new Object[] {
				new BigDecimal(personId1.getKeyValueAsString()),
				new BigDecimal(personId2.getKeyValueAsString())
			};
			
		try {
            List results = getHibernateTemplate().findByNamedQueryAndNamedParam(
            		FIND_PERSON_UNMERGE_BY_PERSON_IDS, paramNames, values);

            PersonUnmergeInfo unmergeInfo = ((results == null) || results.isEmpty()) ? null
                    : (PersonUnmergeInfo) results.get(0);

            return unmergeInfo;
            
        } catch (DataAccessException e) {
            throw new DAOException("Failed to find PersonUnmergeInfo by personId.", e);
        }
	}	

}
