package gov.va.med.esr.common.persistent.person.hibernate;

import java.util.List;

import org.hibernate.HibernateException;
import gov.va.med.esr.common.model.person.PersonTraits;
import gov.va.med.esr.common.persistent.person.PersonTraitsDAO;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.hibernate.GenericDAOImpl;
/**
 * DAO implementation to retrieve PersonTraits - does not retrieve data through PSIM API.
 *   
 * @author DNS   GALLAS
 * Created on June 24, 2008
 * @version 1.0
 * 
 * Copyright  2008 VHA. All rights reserved
 */
public class PersonTraitsDAOImpl extends GenericDAOImpl implements PersonTraitsDAO
{
    
    /**
     * 
     */
    private static final long serialVersionUID = -7763294098172040839L;
    private static final String GET_BY_VPID= "reportPersonTraitsQuery_GetByVPID";
    private static final String PARAM_VPID= "vpid";
    
    
    public PersonTraits getPersonTraitsByVPID(String VPID) throws DAOException
    {
        try
        {
			List results = findByNamedQueryAndNamedParam(GET_BY_VPID, PARAM_VPID, VPID);
            
            if (results.size() > 1) 
            {
                // Return null if more than 1 found
                return null;
            }   

			PersonTraits personTraits = ((results == null) || results.isEmpty()) ? null
					: ((PersonTraits)results.get(0));

			return personTraits;
            
        }
        catch(HibernateException e)
        {
            throw new DAOException("Failed to get PersonTraits by VPID: " + VPID, e);
        }
     }
}
