package gov.va.med.esr.common.persistent.person.hibernate;

import gov.va.med.esr.common.persistent.person.MECPeriodDAO;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.hibernate.GenericDAOImpl;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.Validate;

public class MECPeriodDAOImpl  extends GenericDAOImpl implements MECPeriodDAO {

	private static final long serialVersionUID = 8793888126514734883L;

	public static final String MECPERIOD_BY_PERSON_ID_QUERY = "MECPeriod_GetByPersonId";
	public static final String MEC_RECORDS_TO_PROCESS_QUERY = "MECPeriod_GetListToProcess";
	public static final String MEC_BY_DATE = "MECPeriod_GetPeriodByDate";
	public static final String PARAM_PERSON_ID = "personId";
	public static final String PARAM_CALENDAR_YEAR = "calendarYear";
	public static final String PARAM_BATCH_SIZE = "batchSize";
	public static final String PARAM_DATE = "statusDate";

	/*SELECT
   ROWID, MEC_PERIOD_ID, PERSON_ID, MEC_START_DATE,
   MEC_END_DATE, RECORD_CREATED_BY, RECORD_CREATED_DATE,
   RECORD_MODIFIED_BY, RECORD_MODIFIED_DATE, RECORD_MODIFIED_COUNT
FROM ADR.MEC_PERIOD*/

	private static Map uiFieldToColumnMap;
    static
    {
    	uiFieldToColumnMap = new HashMap();
    	uiFieldToColumnMap.put("result.mecPeriodId", "mecPeriodId");
    	uiFieldToColumnMap.put("result.personId", "personId");
    	uiFieldToColumnMap.put("result.mecStartDate", "mecStartDate");
    	uiFieldToColumnMap.put("result.mecEndDate", "mecEndDate");
    }


    /**
	 * Looks up all MEC Period record by person_id.
	 * @param person_id The person_id to lookup
	 * @return
	 * @throws DAOException
	 */
	public List getByPersonId(BigDecimal personId) throws DAOException
	{
		Validate.notNull(personId, "personId cannot be null");
		try
        {
			return findByNamedQueryAndNamedParam(MECPERIOD_BY_PERSON_ID_QUERY, PARAM_PERSON_ID, personId);
		}
        catch(Exception e)
        {
            throw new DAOException("MEC Period getByPersonId failed for personId: " + personId, e);
        }

	}

	public List getMECPeriodByDate(BigDecimal personId, String statusDate) throws DAOException {
		try
        {
			return findByNamedQueryAndNamedParam(MEC_BY_DATE, new String[] {PARAM_PERSON_ID, PARAM_DATE}, new Object[] {personId, statusDate});
		}
        catch(Exception e)
        {
            throw new DAOException("MEC Period getByPersonId failed for personId: " + personId, e);
        }
	}

	/**
	 * Get Records to submit for cal year
	 * @param calendarYear The year to search
	 * @param batchSize The rownum limit of the batch to return
	 * @return
	 * @throws DAOException
	 */
	public List getMECRecordsToProcess(String calendarYear, String batchSize) throws DAOException
	{
		try
        {
			List results = findByNamedQueryAndNamedParam(MEC_RECORDS_TO_PROCESS_QUERY, new String[] {PARAM_CALENDAR_YEAR, PARAM_BATCH_SIZE}, new String[] {calendarYear, batchSize});

		    return results;
		}
        catch(Exception e)
        {
            throw new DAOException("MECPeriod getRecordsToProcess failed for calendaryear: " + calendarYear, e);
        }
	}

}
