/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.persistent.person.hibernate;

// Java Classes
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import org.hibernate.HibernateException;
import org.hibernate.type.StringType;
import org.hibernate.usertype.UserType;

import gov.va.med.esr.common.model.person.ICN;

/**
 * @author Martin Francisco
 */
public class ICNType
    implements UserType
{
    private final StringType valueType;
    private final StringType checkSumType;

    public ICNType()
    {
        super();

        this.valueType = new StringType();
        this.checkSumType = new StringType();
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.hibernate.UserType#sqlTypes()
     */
    public int[] sqlTypes()
    {
        return new int[] {
            this.valueType.sqlType(),
            this.checkSumType.sqlType() };
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.hibernate.UserType#returnedClass()
     */
    public Class returnedClass()
    {
        return ICN.class;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.hibernate.UserType#equals(java.lang.Object, java.lang.Object)
     */
    public boolean equals(Object x, Object y) throws HibernateException
    {
        return ((x == y) || ((x != null) && x.equals(y)));
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.hibernate.UserType#nullSafeGet(java.sql.ResultSet,
     *      java.lang.String[], java.lang.Object)
     */
    public Object nullSafeGet(ResultSet rs, String[] names, Object owner)
        throws HibernateException,
        SQLException
    {
        String value = (String)this.valueType.nullSafeGet(rs, names[0]);
        String checkSum = (String)this.checkSumType.nullSafeGet(rs, names[1]);

        if(value != null)
        {
            return new ICN(value, checkSum);
        }
        else
        {
            return null;
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.hibernate.UserType#nullSafeSet(java.sql.PreparedStatement,
     *      java.lang.Object, int)
     */
    public void nullSafeSet(PreparedStatement st, Object value, int index)
        throws HibernateException,
        SQLException
    {
        if(value != null)
        {
            ICN icn = (ICN)value;

            this.valueType.nullSafeSet(st, icn.getValue(), index);
            this.checkSumType.nullSafeSet(st, icn.getCheckSum(), index + 1);
        }
        else
        {
            this.valueType.nullSafeSet(st, null, index);
            this.checkSumType.nullSafeSet(st, null, index + 1);
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.hibernate.UserType#deepCopy(java.lang.Object)
     */
    public Object deepCopy(Object value) throws HibernateException
    {
        if(value == null)
        {
            return null;
        }
        else
        {
            ICN icn = (ICN)value;

            return new ICN(icn.getValue(), icn.getCheckSum());
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.hibernate.UserType#isMutable()
     */
    public boolean isMutable()
    {
        return true;
    }
	
	public Serializable disassemble(Object value) throws HibernateException {
		return (Serializable) value;
	}

	public Object assemble(Serializable cached, Object owner) throws HibernateException {
		return cached;
	}

	public Object replace(Object original, Object target, Object owner) throws HibernateException {
		return original;
	}
	
	public int hashCode(Object x) throws HibernateException {
		return x.hashCode();
	}	
	
}