/********************************************************************
 * Copyright  2004-2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.persistent.person.hibernate;

// Java Classes
import java.util.List;

import gov.va.med.esr.common.model.person.HealthCareProvider;
import gov.va.med.esr.common.model.person.PreferredFacilityPerson;
import gov.va.med.esr.common.persistent.person.HealthCareProviderDAO;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.hibernate.GenericDAOImpl;

/**
 * This class is a DAO implementation that searches and retries HealthCareProvider object.
 *
 * @author 
 * @version 
 */
public class HealthCareProviderDAOImpl extends GenericDAOImpl implements HealthCareProviderDAO
{
	/**
    * An instance of serialVersionUID
    */
	private static final long serialVersionUID = 4827114527875794158L;

	private static final String GET_BY_PRACTIONERID = "providerQuery_GetByPractitionerId";
	private static final String PARAM_FOR_GET_BY_PRACTIONER_ID = "PractitionerId";

	/**
	 * 
	 * @param practitionerId
	 * @return
	 * @throws DAOException
	 */
    public HealthCareProvider findByPractitionerID(String practitionerId) throws DAOException {
    	if(practitionerId == null)
    		return null;

        List providers = findByNamedQueryAndNamedParam(GET_BY_PRACTIONERID, PARAM_FOR_GET_BY_PRACTIONER_ID, practitionerId);
        return (HealthCareProvider) (providers.size() >= 1 ? providers.get(0) : null);
	}

 }