package gov.va.med.esr.common.persistent.person.hibernate;

import java.util.List;

import org.apache.commons.lang.Validate;
import org.hibernate.HibernateException;
import org.hibernate.lob.SerializableClob;

import gov.va.med.esr.common.model.person.ApplicationInProcess;
import gov.va.med.esr.common.model.person.EnrollmentApplication;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.PersonTraits;
import gov.va.med.esr.common.persistent.person.EnrollmentApplicationDAO;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.hibernate.GenericDAOImpl;
import gov.va.med.fw.service.ServiceException;

public class EnrollmentApplicationDAOImpl extends GenericDAOImpl implements EnrollmentApplicationDAO {

	/**
	 * 
	 */
	private static final long serialVersionUID = -8511001891879508196L;

	private static final String PARAM_SSN = "ssn";
	private static final String PARAM_ICN = "icn";
	
	private static final String REGISTRATION_BY_ICN_QUERY = "EnrollmentApplication_by_icn";
	private static final String INPROCESS_PERSON_XML_BY_ICN = "InProcess_Person_Xml_GetByIcn";
	private static final String APPLICATION_STATUS_CODE_BY_ICN = "Application_Status_Code_GetByIcn";
//	private static final String REGISTRATION_INPROCESS_BY_ICN_QUERY = "EnrollmentApplication_in_process_by_icn";
	
	
	
	public void saveInProcess(EnrollmentApplication ea) throws DAOException {
		try {
			this.saveObject(ea);
		} catch (DAOException e) {
			throw e;
		}
	}
	
	/**
	 * Looks up a person who is in-process or New Application, by icn, and returns a Person object.
	 * @param icn The icn to lookup
	 * @return A Person object.
	 */
	public EnrollmentApplication getByIcn(String icn) throws DAOException {
		Validate.notNull(icn, "ICN cannot be null");
		
		try
        {
			List results = findByNamedQueryAndNamedParam(REGISTRATION_BY_ICN_QUERY, PARAM_ICN, icn);
		    verifyDataIntegrity(icn, results);

		    return results.size()==0? null : (EnrollmentApplication)results.get(0);
		}
        catch(Exception e)
        {
            throw new DAOException("getByIcn failed for icn: " + icn, e);
        } 
 	}
	
	
	/**
	 * get the application status code , by icn, and returns a Person object.
	 * @param icn The icn to lookup
	 * @return A string of application status code.
	 */
	public List getApplicationStatusCodeListByIcn(String icn) throws DAOException {
		Validate.notNull(icn, "ICN cannot be null");
		
		try
        {
			return findByNamedQueryAndNamedParam(APPLICATION_STATUS_CODE_BY_ICN, PARAM_ICN, icn);

		}
        catch(Exception e)
        {
            throw new DAOException("getByIcn failed for icn: " + icn, e);
        } 
 	}
	public SerializableClob getInProcessPersonXmlByIcn(String icn) throws DAOException {
		Validate.notNull(icn, "ICN cannot be null");

		try
        {
			List results = findByNamedQueryAndNamedParam(INPROCESS_PERSON_XML_BY_ICN, PARAM_ICN, icn);
		    verifyDataIntegrity(icn, results);
          
		    if (results.size() > 0) {
				return ((SerializableClob)results.get(0));	
			}
       }
        catch(Exception e)
        {
            throw new DAOException("getInProcessPersonByIcn failed for icn: " + icn, e);
        } 
 		return null;
    }

	
/*	public EnrollmentApplication getInProcessPersonByIcn(String icn) throws DAOException {
		
		Validate.notNull(icn, "ICN cannot be null");

		Person p = null;
		try
        {
			List results = findByNamedQueryAndNamedParam(REGISTRATION_INPROCESS_BY_ICN_QUERY, PARAM_ICN, icn);
		    verifyDataIntegrity(icn, results);
          
		    return results.size()==0? null : (EnrollmentApplication)results.get(0);
		}
        catch(Exception e)
        {
            throw new DAOException("InProcessPersonByIcn failed for icn: " + icn, e);
        } 
    }*/

    private void verifyDataIntegrity(String icn, List results) throws DAOException {
        if (results.size() > 1) {
     		throw new DAOException("Found more than one record in AplicationInProcess for ICN(VPID): " + icn);
        }
    }
}
