package gov.va.med.esr.common.persistent.person;

import gov.va.med.esr.common.model.lookup.VOAApplicationStatus;
import gov.va.med.esr.common.model.person.VOAApplication;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.DAOOperations;

import java.math.BigDecimal;
import java.util.List;

import gov.va.med.fw.persistent.MaxRecordsExceededException;
import gov.va.med.fw.service.pagination.SearchQueryInfo;

public interface VOAApplicationDAO extends DAOOperations {

	/**
	 * Looks up ApplicationInProcess record by icn.
	 * @param icn The icn to lookup
	 * @return
	 * @throws DAOException
	 */
	public List getByPersonId(BigDecimal personId) throws DAOException;

	public List getBySSN(String ssn) throws DAOException;

	/**
	 * Looks up a person In-Process or New Application, by ICN.
	 * @param icn The icn to lookup
	 * @return
	 * @throws DAOException
	 */
	public VOAApplication getByApplicationId(BigDecimal applicationId) throws DAOException;

	public List getByFQID(String fqid) throws DAOException;

	/**
	 * Get VOA Resubmission Applications
	 * @return
	 * @throws DAOException
	 */
	public List getVOAResubmissionApplications() throws DAOException;

	public List find(SearchQueryInfo searchCriteria) throws DAOException, MaxRecordsExceededException;

}
