/********************************************************************
 * Copyright  2004-2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.persistent.person;

// Java Classes
import java.util.List;

import gov.va.med.esr.common.model.person.PreferredFacilityPerson;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.common.model.person.id.VPIDEntityKey;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.DAOOperations;

/**
 * This interface defines various DAO methods for searching and retrieving HealthCareProvider objects.
 */
public interface PreferredFacilityDAO extends DAOOperations
{
    /**
     * Method to retrieve a lightweight Person by VPID
     * 
     * @param key The VPID Key
     * @return The fully built Person
     * @throws DAOException If any errors were encountered.
     */
    public PreferredFacilityPerson getPreferredFacilityPersonByVPID(VPIDEntityKey key) throws DAOException;
	
    /**
     * Find a PreferredFacility object for this person given the facilityId.
     *
     * @param practitionerId The practitionerId
     *
     * @return 
     * @throws DAOException if there was an error trying to find the search results.
     */
   // ?? need?? public PreferredFacility findByFacilityID(Person person, String facilityId) throws DAOException;
 
    public List getChildVaFacility(List parentSiteIds) throws DAOException;
    
    
    /**
     * Given a person id, count the enrollment records in the enrollment determination history table.
     *
     * @param personId The personId
     *
     * @return int
     * @throws DAOException if there was an error trying to find the search results.
     */
 
    public int getEnrollmentRecordCount(PersonEntityKey personId) throws DAOException;
    
}