/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.persistent.person;

import java.util.List;
import java.util.Set;

import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.model.RolePrincipalImpl;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.DAOOperations;
import gov.va.med.fw.persistent.MaxRecordsExceededException;
import gov.va.med.fw.security.UserPrincipal;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.service.pagination.SearchQueryInfo;

import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.PersonMergeInfo;
import gov.va.med.esr.common.model.person.PersonUnmergeInfo;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKey;
import gov.va.med.esr.common.model.security.CapabilitySet;
import gov.va.med.esr.common.model.security.UserLastLoginInfo;

/**
 * A DAO to add, update and delete PersonMergeInfo data.
 * 
 * @author DNS   CHENJ2
 */
public interface PersonUnmergeDAO extends DAOOperations {
	
	PersonUnmergeInfo findByPersonIds(PersonIdEntityKey personId1, PersonIdEntityKey personId2) throws DAOException;

  }