/********************************************************************
 * Copyright  2004-2006 VHA. All rights reserved.
 ********************************************************************/
package gov.va.med.esr.common.persistent.person;

// Java classes
import java.util.List;

import gov.va.med.esr.common.model.person.PersonMergeInfo;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKey;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.DAOOperations;
import gov.va.med.fw.persistent.MaxRecordsExceededException;
import gov.va.med.fw.service.pagination.SearchQueryInfo;

/**
 * A DAO to add, update, delete, and search for PersonMergeInfo data.
 * 
 * @author DNS   CHENJ2
 */
public interface PersonMergeDAO extends DAOOperations {
	/**
	 * Gets PersonMergeInfo based on the person entity key of the "primary"
	 * person
	 * 
	 * @param personId
	 *            the person Id of the person merge info to receive
	 * 
	 * @return The person merge info
	 * @throws DAOException
	 *             If any errors were encountered.
	 */
	PersonMergeInfo getPersonMergeInfo(PersonIdEntityKey personId)
			throws DAOException;

	PersonMergeInfo findByPersonIds(PersonIdEntityKey personId1,
			PersonIdEntityKey personId2) throws DAOException;

	/**
	 * Gets PersonMergeInfo based on the person entity keys of the primary and deprecated persons
	 * 
	 * @param primaryPersonId
	 *            the person Id of the primary person id
	 * @param deprecatedPersonId
	 *            the person Id of the deprecated person id 
	 * @return The person merge info
	 * @throws DAOException
	 *             If any errors were encountered.
	 */
//	PersonMergeInfo findByPrimaryDeprecatedIds(PersonIdEntityKey primaryPersonId,
//		         PersonIdEntityKey deprecatedPersonId) throws DAOException;
	List findByPrimaryDeprecatedIds(PersonIdEntityKey primaryPersonId,
	         PersonIdEntityKey deprecatedPersonId) throws DAOException;
	/**
	 * Loads all non-completed person merge info records
	 * 
	 * @return The list of person merge info records
	 * @throws DAOException
	 *             if any problems were encountered
	 */
	List loadAllNotCompleted() throws DAOException;
    
    /**
     * Loads all non-completed person merge info records
     *
     * @param searchQueryInf The search criteria
     * @return The list of person merge info records
     * @throws DAOException if any problems were encountered
     */
    List loadAllNotCompleted(SearchQueryInfo searchQueryInf) throws DAOException, MaxRecordsExceededException;


	List findNotCompletedByPrimaryPersonEntityKeys(List personEntityKeyList,
			SearchQueryInfo searchQueryInfo) throws DAOException,
			MaxRecordsExceededException;
	
	/**
	 * Gets PersonMergeInfo based on the person entity key of the "deprecated"
	 * person
	 * 
	 * @param personId
	 *            the deprecated person Id of the person merge info to receive
	 * 
	 * @return The person merge info
	 * @throws DAOException
	 *             If any errors were encountered.
	 */
	PersonMergeInfo getPersonMergeInfoByDeprecatedId(PersonIdEntityKey personId) throws DAOException;
}